/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.strainers.block.custom;

import com.benbenlaw.strainers.block.entity.ModBlockEntities;
import com.benbenlaw.strainers.block.entity.StrainerTankBlockEntity;
import com.benbenlaw.strainers.item.StrainersDataComponents;
import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.fluids.SimpleFluidContent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StrainerTankBlock
extends BaseEntityBlock {
    public static final MapCodec<StrainerTankBlock> CODEC = StrainerTankBlock.simpleCodec(StrainerTankBlock::new);
    public FluidState fluidState = Fluids.EMPTY.defaultFluidState();

    public StrainerTankBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @NotNull
    public InteractionResult useWithoutItem(@NotNull BlockState blockState, @NotNull Level level, @NotNull BlockPos blockPos, @NotNull Player player, @NotNull BlockHitResult hit) {
        if (level.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (!(blockEntity instanceof StrainerTankBlockEntity)) {
            return InteractionResult.FAIL;
        }
        StrainerTankBlockEntity entity = (StrainerTankBlockEntity)blockEntity;
        StrainerTankBlockEntity strainerTankBlockEntity = (StrainerTankBlockEntity)level.getBlockEntity(blockPos);
        if (strainerTankBlockEntity != null && strainerTankBlockEntity.onPlayerUse(player, InteractionHand.MAIN_HAND)) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    protected void onPlace(BlockState blockState, Level level, BlockPos blockPos, BlockState currentState, boolean allow) {
        super.onPlace(blockState, level, blockPos, currentState, allow);
        StrainerTankBlockEntity tankEntity = (StrainerTankBlockEntity)level.getBlockEntity(blockPos);
        assert (tankEntity != null);
        if (!tankEntity.getFluidStack().isEmpty()) {
            return;
        }
        if (currentState.getFluidState().isSource()) {
            tankEntity.setFluid(new FluidStack(currentState.getFluidState().getType(), 1000));
        }
    }

    public void setPlacedBy(Level level, BlockPos blockPos, BlockState blockState, @Nullable LivingEntity entity, ItemStack itemStack) {
        super.setPlacedBy(level, blockPos, blockState, entity, itemStack);
        StrainerTankBlockEntity tankEntity = (StrainerTankBlockEntity)level.getBlockEntity(blockPos);
        assert (tankEntity != null);
        if (itemStack.has(StrainersDataComponents.FLUID_TYPE)) {
            SimpleFluidContent fluidContent = (SimpleFluidContent)itemStack.get(StrainersDataComponents.FLUID_TYPE);
            assert (fluidContent != null);
            Fluid fluid = fluidContent.getFluid();
            tankEntity.setFluid(new FluidStack(fluid, 1000));
        }
    }

    public void appendHoverText(ItemStack itemStack, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Item.TooltipContext context, @NotNull List<Component> components, @NotNull TooltipFlag flag) {
        if (itemStack.has(StrainersDataComponents.FLUID_TYPE)) {
            SimpleFluidContent fluidContent = (SimpleFluidContent)itemStack.get(StrainersDataComponents.FLUID_TYPE);
            assert (fluidContent != null);
            String fluidAsString = fluidContent.getFluid().getFluidType().getDescriptionId().toString();
            FluidType fluid = ((Fluid)BuiltInRegistries.FLUID.get(ResourceLocation.tryParse((String)fluidAsString))).getFluidType();
            components.add((Component)Component.literal((String)"Contains: ").append((Component)Component.translatable((String)fluidAsString)).withStyle(ChatFormatting.GREEN));
        }
        super.appendHoverText(itemStack, context, components, flag);
    }

    @NotNull
    public RenderShape getRenderShape(@NotNull BlockState blockState) {
        return RenderShape.MODEL;
    }

    public void onRemove(BlockState blockState, @NotNull Level level, @NotNull BlockPos blockPos, BlockState newBlockState, boolean isMoving) {
        blockState.getBlock();
        newBlockState.getBlock();
        super.onRemove(blockState, level, blockPos, newBlockState, isMoving);
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return new StrainerTankBlockEntity(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level level, @NotNull BlockState blockState, @NotNull BlockEntityType<T> blockEntityType) {
        return StrainerTankBlock.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)ModBlockEntities.STRAINER_TANK_BLOCK_ENTITY.get()), (world, blockPos, thisBlockState, blockEntity) -> blockEntity.tick());
    }
}

