/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.smartcrafting.screen;

import com.benbenlaw.smartcrafting.config.SmartCraftingConfig;
import com.benbenlaw.smartcrafting.networking.packets.SyncFavoriteRecipesClient;
import com.benbenlaw.smartcrafting.networking.packets.SyncSortTypeClient;
import com.benbenlaw.smartcrafting.networking.payload.SmartCraftingRecipePayload;
import com.benbenlaw.smartcrafting.screen.SmartCraftingMenus;
import com.benbenlaw.smartcrafting.util.SmartCraftingTags;
import dev.ftb.mods.ftbchunks.api.Protection;
import dev.ftb.mods.ftbchunks.data.ClaimedChunkManagerImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.StonecutterRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class SmartCraftingMenu
extends AbstractContainerMenu {
    protected Level level;
    protected ContainerData data;
    protected Player player;
    protected BlockPos blockPos;
    private final NonNullList<ItemStack> lastInventorySnapshot;
    public String sortType;
    public int handlers;

    public SmartCraftingMenu(int containerID, Inventory inventory, FriendlyByteBuf extraData) {
        this(containerID, inventory, extraData.readBlockPos(), (ContainerData)new SimpleContainerData(2));
    }

    public SmartCraftingMenu(int containerID, Inventory inventory, BlockPos blockPos, ContainerData data) {
        super((MenuType)SmartCraftingMenus.SMART_CRAFTING_MENU.get(), containerID);
        this.player = inventory.player;
        this.blockPos = blockPos;
        this.level = inventory.player.level();
        this.data = data;
        this.sortType = this.player.getPersistentData().getString("smart_crafting_sort_type");
        this.lastInventorySnapshot = NonNullList.withSize((int)this.player.getInventory().items.size(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < this.player.getInventory().items.size(); ++i) {
            this.lastInventorySnapshot.set(i, (Object)((ItemStack)this.player.getInventory().items.get(i)).copy());
        }
        if (!this.level.isClientSide) {
            this.updateValidRecipes();
            PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)inventory.player), (CustomPacketPayload)new SyncSortTypeClient(this.player.getPersistentData().getString("smart_crafting_sort_type")), (CustomPacketPayload[])new CustomPacketPayload[0]);
            ListTag listTag = this.player.getPersistentData().getList("smart_crafting_favorites", 8);
            List<String> favorites = listTag.stream().map(Tag::getAsString).toList();
            PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)inventory.player), (CustomPacketPayload)new SyncFavoriteRecipesClient(favorites), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        SmartCraftingMenu.checkContainerSize((Container)inventory, (int)2);
        this.addPlayerInventory(inventory);
        this.addPlayerHotbar(inventory);
        this.addDataSlots(data);
    }

    public void updateValidRecipes() {
        if (this.level.isClientSide) {
            return;
        }
        List<RecipeHolder<?>> recipes = this.getValidRecipes();
        List<ResourceLocation> recipeIds = recipes.stream().map(RecipeHolder::id).toList();
        this.sendRecipesToClient(recipeIds);
    }

    private void sendRecipesToClient(List<ResourceLocation> recipeIds) {
        SmartCraftingRecipePayload packet = new SmartCraftingRecipePayload(recipeIds);
        PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)this.player), (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public List<RecipeHolder<?>> getValidRecipes() {
        if (this.level.isClientSide) {
            return Collections.emptyList();
        }
        long startTime = System.nanoTime();
        RecipeManager rm = this.level.getRecipeManager();
        List craftingRecipes = rm.getAllRecipesFor(RecipeType.CRAFTING);
        List stonecutterRecipes = rm.getAllRecipesFor(RecipeType.STONECUTTING);
        Container inv = this.buildCombinedInventory();
        ArrayList allRecipes = new ArrayList();
        int craftingMatchCount = 0;
        for (RecipeHolder holder : craftingRecipes) {
            if (!this.recipeHasMatchingIngredients(holder.value(), inv) || !this.canCraftFromInventory((CraftingRecipe)holder.value(), inv)) continue;
            allRecipes.add(holder);
            ++craftingMatchCount;
        }
        int stonecutterMatchCount = 0;
        if (this.isStonecutterNearby(this.player)) {
            for (RecipeHolder holder : stonecutterRecipes) {
                if (!this.recipeHasMatchingIngredients(holder.value(), inv) || !this.canCraftStonecutterFromInventory((StonecutterRecipe)holder.value(), inv)) continue;
                allRecipes.add(holder);
                ++stonecutterMatchCount;
            }
        }
        return allRecipes;
    }

    private List<IItemHandler> findConnectedItemHandlers() {
        ArrayList<IItemHandler> itemHandlers = new ArrayList<IItemHandler>();
        int radius = (Integer)SmartCraftingConfig.storageRangeCheck.get();
        BlockPos.betweenClosedStream((BlockPos)this.blockPos.offset(-radius, -radius / 2, -radius), (BlockPos)this.blockPos.offset(radius, radius / 2, radius)).forEach(pos -> {
            BlockEntity be = this.level.getBlockEntity(pos);
            if (be != null && (this.level.getBlockState(pos).is(SmartCraftingTags.Blocks.WHITELISTED_STORAGE) || SmartCraftingMenu.isAllowedViaConfig(this.level.getBlockState(pos).getBlock())) && this.canAccessBlock((BlockPos)pos)) {
                BlockPos otherPos;
                Direction dir;
                ChestBlockEntity chest;
                ChestType type;
                if (be instanceof ChestBlockEntity && (type = (ChestType)(chest = (ChestBlockEntity)be).getBlockState().getValue((Property)ChestBlock.TYPE)) != ChestType.SINGLE && (dir = ChestBlock.getConnectedDirection((BlockState)chest.getBlockState())) != null && (otherPos = pos.relative(dir)).compareTo((Vec3i)pos) < 0) {
                    return;
                }
                IItemHandler handler = (IItemHandler)Capabilities.ItemHandler.BLOCK.getCapability(this.level, pos, this.level.getBlockState(pos), be, null);
                if (handler != null) {
                    itemHandlers.add(handler);
                }
            }
        });
        this.handlers = itemHandlers.size();
        return itemHandlers;
    }

    private static boolean isAllowedViaConfig(Block block) {
        ResourceLocation blockId = BuiltInRegistries.BLOCK.getKey((Object)block);
        for (String id : (List)SmartCraftingConfig.validStorageBlocks.get()) {
            if (!blockId.toString().equalsIgnoreCase(id)) continue;
            return true;
        }
        return false;
    }

    private boolean canAccessBlock(BlockPos pos) {
        Player player = this.player;
        if (!(player instanceof ServerPlayer)) {
            return false;
        }
        ServerPlayer serverPlayer1 = (ServerPlayer)player;
        if (ModList.get().isLoaded("ftbchunks")) {
            return !ClaimedChunkManagerImpl.getInstance().shouldPreventInteraction((Entity)serverPlayer1, InteractionHand.MAIN_HAND, pos, Protection.EDIT_AND_INTERACT_BLOCK, null);
        }
        return true;
    }

    private Container buildCombinedInventory() {
        ArrayList<ItemStack> combinedStacks = new ArrayList<ItemStack>();
        for (ItemStack stack : this.player.getInventory().items) {
            if (stack.isEmpty()) continue;
            combinedStacks.add(stack.copy());
        }
        for (IItemHandler handler : this.findConnectedItemHandlers()) {
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stack = handler.getStackInSlot(i);
                if (stack.isEmpty()) continue;
                combinedStacks.add(stack.copy());
            }
        }
        SimpleContainer combined = new SimpleContainer(combinedStacks.size());
        for (int i = 0; i < combinedStacks.size(); ++i) {
            combined.setItem(i, (ItemStack)combinedStacks.get(i));
        }
        return combined;
    }

    private boolean consumeIngredientFromAll(Ingredient ingredient, int count) {
        int remaining = count;
        for (int i = 0; i < this.player.getInventory().getContainerSize(); ++i) {
            ItemStack stack = this.player.getInventory().getItem(i);
            if (stack.isEmpty() || !ingredient.test(stack)) continue;
            int toTake = Math.min(stack.getCount(), remaining);
            stack.shrink(toTake);
            if (stack.isEmpty()) {
                this.player.getInventory().setItem(i, ItemStack.EMPTY);
            }
            if ((remaining -= toTake) > 0) continue;
            return true;
        }
        for (IItemHandler handler : this.findConnectedItemHandlers()) {
            for (int i = 0; i < handler.getSlots(); ++i) {
                int toTake;
                ItemStack extracted;
                ItemStack stack = handler.getStackInSlot(i);
                if (stack.isEmpty() || !ingredient.test(stack) || (extracted = handler.extractItem(i, toTake = Math.min(stack.getCount(), remaining), false)).isEmpty() || (remaining -= extracted.getCount()) > 0) continue;
                return true;
            }
        }
        return remaining <= 0;
    }

    private boolean isStonecutterNearby(Player player) {
        int radius = (Integer)SmartCraftingConfig.stonecutterRangeCheck.get();
        BlockPos playerPos = player.blockPosition();
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dy = -radius; dy <= radius; ++dy) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    BlockPos checkPos = playerPos.offset(dx, dy, dz);
                    if (!this.level.getBlockState(checkPos).is(Blocks.STONECUTTER)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean canCraftFromInventory(CraftingRecipe recipe, Container inv) {
        CraftingInput input = this.buildCraftingInputForRecipe(recipe, inv);
        return recipe.matches((RecipeInput)input, this.level);
    }

    private boolean canCraftStonecutterFromInventory(StonecutterRecipe recipe, Container inv) {
        for (Ingredient ingredient : recipe.getIngredients()) {
            boolean found = false;
            for (int i = 0; i < inv.getContainerSize(); ++i) {
                ItemStack stack = inv.getItem(i);
                if (stack.isEmpty() || !ingredient.test(stack)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    private CraftingInput buildCraftingInputForRecipe(CraftingRecipe recipe, Container inv) {
        NonNullList grid = NonNullList.withSize((int)9, (Object)ItemStack.EMPTY);
        NonNullList ingredients = recipe.getIngredients();
        int[] usedSlots = new int[inv.getContainerSize()];
        if (recipe instanceof ShapedRecipe) {
            ShapedRecipe shaped = (ShapedRecipe)recipe;
            int width = shaped.getWidth();
            int height = shaped.getHeight();
            for (int row = 0; row < height; ++row) {
                block1: for (int col = 0; col < width; ++col) {
                    Ingredient ing;
                    int recipeIndex = row * width + col;
                    int gridIndex = row * 3 + col;
                    if (recipeIndex >= ingredients.size() || (ing = (Ingredient)ingredients.get(recipeIndex)).isEmpty()) continue;
                    for (int i = 0; i < inv.getContainerSize(); ++i) {
                        ItemStack stack = inv.getItem(i);
                        if (stack.isEmpty() || usedSlots[i] >= stack.getCount() || !ing.test(stack)) continue;
                        ItemStack copy = stack.copy();
                        copy.setCount(1);
                        grid.set(gridIndex, (Object)copy);
                        int n = i;
                        usedSlots[n] = usedSlots[n] + 1;
                        continue block1;
                    }
                }
            }
        } else {
            int placed = 0;
            block3: for (Ingredient ing : ingredients) {
                if (ing.isEmpty()) continue;
                for (int i = 0; i < inv.getContainerSize(); ++i) {
                    ItemStack stack = inv.getItem(i);
                    if (stack.isEmpty() || usedSlots[i] >= stack.getCount() || !ing.test(stack)) continue;
                    ItemStack copy = stack.copy();
                    copy.setCount(1);
                    grid.set(placed, (Object)copy);
                    int n = i;
                    usedSlots[n] = usedSlots[n] + 1;
                    ++placed;
                    continue block3;
                }
            }
        }
        return CraftingInput.ofPositioned((int)3, (int)3, (List)grid).input();
    }

    public void craftRecipeById(ResourceLocation recipeId, boolean shiftClick) {
        if (this.level.isClientSide) {
            return;
        }
        RecipeManager rm = this.level.getRecipeManager();
        Optional optionalRecipe = rm.byKey(recipeId);
        if (optionalRecipe.isEmpty()) {
            return;
        }
        Recipe recipeHolder = ((RecipeHolder)optionalRecipe.get()).value();
        if (recipeHolder instanceof CraftingRecipe) {
            Container combinedInv;
            CraftingInput input;
            CraftingRecipe craftingRecipe = (CraftingRecipe)recipeHolder;
            int maxCrafts = shiftClick ? this.getMaxCraftableAmount(craftingRecipe) : 1;
            for (int i = 0; i < maxCrafts && craftingRecipe.matches((RecipeInput)(input = this.buildCraftingInputForRecipe(craftingRecipe, combinedInv = this.buildCombinedInventory())), this.level); ++i) {
                ItemStack result = craftingRecipe.assemble((RecipeInput)input, (HolderLookup.Provider)this.level.registryAccess());
                if (!this.player.getInventory().add(result.copy())) {
                    this.player.drop(result.copy(), false);
                }
                NonNullList ingredients = craftingRecipe.getIngredients();
                HashMap<Ingredient, Integer> ingredientCounts = new HashMap<Ingredient, Integer>();
                for (Ingredient ingredient : ingredients) {
                    if (ingredient.isEmpty()) continue;
                    ingredientCounts.put(ingredient, ingredientCounts.getOrDefault(ingredient, 0) + 1);
                }
                for (Map.Entry entry : ingredientCounts.entrySet()) {
                    if (this.consumeIngredientFromAll((Ingredient)entry.getKey(), (Integer)entry.getValue())) continue;
                    return;
                }
                NonNullList remainders = craftingRecipe.getRemainingItems((RecipeInput)input);
                for (ItemStack remainder : remainders) {
                    if (remainder.isEmpty() || this.player.getInventory().add(remainder)) continue;
                    this.player.drop(remainder, false);
                }
            }
            this.player.playNotifySound(SoundEvents.LEVER_CLICK, SoundSource.PLAYERS, 1.0f, 1.0f);
            this.player.getInventory().setChanged();
            this.player.inventoryMenu.broadcastChanges();
            this.updateValidRecipes();
            return;
        }
        if (recipeHolder instanceof StonecutterRecipe) {
            Container combinedInv;
            StonecutterRecipe stonecutterRecipe = (StonecutterRecipe)recipeHolder;
            int maxCrafts = shiftClick ? this.getMaxCraftableAmountStonecutter(stonecutterRecipe) : 1;
            for (int i = 0; i < maxCrafts && this.canCraftStonecutterFromInventory(stonecutterRecipe, combinedInv = this.buildCombinedInventory()); ++i) {
                Ingredient ingredient;
                ItemStack result = stonecutterRecipe.assemble(null, (HolderLookup.Provider)this.level.registryAccess());
                if (!this.player.getInventory().add(result.copy())) {
                    this.player.drop(result.copy(), false);
                }
                if (!this.consumeIngredientFromAll(ingredient = (Ingredient)stonecutterRecipe.getIngredients().getFirst(), 1)) break;
            }
            this.player.playNotifySound(SoundEvents.UI_STONECUTTER_TAKE_RESULT, SoundSource.PLAYERS, 1.0f, 1.0f);
            this.player.getInventory().setChanged();
            this.player.inventoryMenu.broadcastChanges();
            this.updateValidRecipes();
        }
    }

    private boolean recipeHasMatchingIngredients(Recipe<?> recipe, Container inv) {
        if (recipe instanceof CraftingRecipe) {
            CraftingRecipe craftingRecipe = (CraftingRecipe)recipe;
            for (Ingredient ingredient : craftingRecipe.getIngredients()) {
                if (ingredient.isEmpty()) continue;
                boolean found = false;
                for (int i = 0; i < inv.getContainerSize(); ++i) {
                    ItemStack stack = inv.getItem(i);
                    if (stack.isEmpty() || !ingredient.test(stack)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
            return true;
        }
        if (recipe instanceof StonecutterRecipe) {
            StonecutterRecipe stonecutterRecipe = (StonecutterRecipe)recipe;
            for (Ingredient ingredient : stonecutterRecipe.getIngredients()) {
                if (ingredient.isEmpty()) continue;
                boolean found = false;
                for (int i = 0; i < inv.getContainerSize(); ++i) {
                    ItemStack stack = inv.getItem(i);
                    if (stack.isEmpty() || !ingredient.test(stack)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private int getMaxCraftableAmount(CraftingRecipe recipe) {
        Container inv = this.buildCombinedInventory();
        int max = Integer.MAX_VALUE;
        for (Ingredient ingredient : recipe.getIngredients()) {
            if (ingredient.isEmpty()) continue;
            int count = 0;
            for (int i = 0; i < inv.getContainerSize(); ++i) {
                ItemStack stack = inv.getItem(i);
                if (!ingredient.test(stack)) continue;
                count += stack.getCount();
            }
            max = Math.min(max, count);
        }
        return Math.max(0, Math.min(max, 64));
    }

    private int getMaxCraftableAmountStonecutter(StonecutterRecipe recipe) {
        Ingredient ingredient = (Ingredient)recipe.getIngredients().getFirst();
        if (ingredient.isEmpty()) {
            return 0;
        }
        int count = 0;
        for (IItemHandler handler : this.findConnectedItemHandlers()) {
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stack = handler.getStackInSlot(i);
                if (stack.isEmpty() || !ingredient.test(stack)) continue;
                count += stack.getCount();
            }
        }
        for (int i = 0; i < this.player.getInventory().getContainerSize(); ++i) {
            ItemStack stack = this.player.getInventory().getItem(i);
            if (stack.isEmpty() || !ingredient.test(stack)) continue;
            count += stack.getCount();
        }
        return Math.max(0, Math.min(count, 64));
    }

    public void broadcastChanges() {
        int i;
        super.broadcastChanges();
        if (this.level.isClientSide) {
            return;
        }
        boolean changed = false;
        NonNullList current = this.player.getInventory().items;
        for (i = 0; i < current.size(); ++i) {
            ItemStack newStack;
            ItemStack oldStack = (ItemStack)this.lastInventorySnapshot.get(i);
            if (ItemStack.matches((ItemStack)oldStack, (ItemStack)(newStack = (ItemStack)current.get(i)))) continue;
            changed = true;
            break;
        }
        if (changed) {
            for (i = 0; i < current.size(); ++i) {
                this.lastInventorySnapshot.set(i, (Object)((ItemStack)current.get(i)).copy());
            }
        }
    }

    @NotNull
    public ItemStack quickMoveStack(Player p_38941_, int p_38942_) {
        return ItemStack.EMPTY;
    }

    public boolean stillValid(@NotNull Player player) {
        return true;
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.addSlot(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 84 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }
}

