/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.colors.block.sets;

import com.benbenlaw.colors.block.sets.PlankLikeBlocksList;
import com.benbenlaw.core.util.ColorList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;

public class ColorsWoodTypes {
    public static final Map<String, WoodType> WOOD_TYPES = new HashMap<String, WoodType>();

    public static WoodType getWoodType(String color, String plank) {
        return WOOD_TYPES.get(color + "_" + plank);
    }

    public static void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            for (WoodType type : WOOD_TYPES.values()) {
                Sheets.addWoodType((WoodType)type);
                System.out.println("[Colors] Added wood type to Sheets: " + type.name());
            }
        });
    }

    static {
        for (String color : ColorList.COLORS) {
            for (String plank : PlankLikeBlocksList.PLANKS) {
                String singularPlank = plank.endsWith("s") ? plank.substring(0, plank.length() - 1) : plank;
                String baseName = color + "_" + singularPlank;
                String setName = baseName + "_wood_set";
                String woodTypeName = baseName + "_sign";
                BlockSetType woodSet = BlockSetType.register((BlockSetType)new BlockSetType(ResourceLocation.fromNamespaceAndPath((String)"colors", (String)setName).toString()));
                WoodType woodType = WoodType.register((WoodType)new WoodType(ResourceLocation.fromNamespaceAndPath((String)"colors", (String)woodTypeName).toString(), woodSet));
                WOOD_TYPES.put(baseName, woodType);
                System.out.println("[Colors] Added wood type: " + woodTypeName);
            }
        }
    }
}

