/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lootjs.loot.modifier.handler;

import com.almostreliable.lootjs.core.LootBucket;
import com.almostreliable.lootjs.loot.modifier.LootAction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public class LightningStrikeAction
implements LootAction {
    private final boolean shouldDamageEntity;

    public LightningStrikeAction(boolean shouldDamageEntity) {
        this.shouldDamageEntity = shouldDamageEntity;
    }

    @Override
    public void apply(LootContext context, LootBucket loot) {
        LightningBolt lightning;
        Vec3 origin = (Vec3)context.getParamOrNull(LootContextParams.ORIGIN);
        if (origin != null && (lightning = (LightningBolt)EntityType.LIGHTNING_BOLT.create((Level)context.getLevel())) != null) {
            lightning.moveTo(origin.x, origin.y, origin.z);
            if (!this.shouldDamageEntity) {
                lightning.setVisualOnly(true);
            }
            context.getLevel().addFreshEntity((Entity)lightning);
        }
    }
}

