/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.warp_pipes.utils;

import com.wenxin2.warp_pipes.blocks.WarpPipeBlock;
import com.wenxin2.warp_pipes.blocks.entities.BaseWarpBlockEntity;
import com.wenxin2.warp_pipes.registries.TagRegistry;
import com.wenxin2.warp_pipes.utils.WP$BlockWarpEntitiesHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public interface WP$BlockWarpPlayersHandler
extends WP$BlockWarpEntitiesHandler {
    /*
     * Enabled aggressive block sorting
     */
    @Override
    default public void enterWarpPipe(Entity entity, Level world, BlockPos pos, BlockPos warpPos, BaseWarpBlockEntity warpBE) {
        BlockState state = world.getBlockState(pos);
        double entityX = entity.getX();
        double entityY = entity.getY();
        double entityZ = entity.getZ();
        int blockX = pos.getX();
        int blockY = pos.getY();
        int blockZ = pos.getZ();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!this.wp$getBlockWarpTeleportConfig() || entity.getType().is(TagRegistry.CANNOT_WARP) || this.wp$doPreventWarp()) {
                if (state.getValue((Property)WarpPipeBlock.FACING) == Direction.UP && entity.isShiftKeyDown() && entityY + (double)entity.getBbHeight() >= (double)(blockY - 1) && entityX < (double)(blockX + 1) && entityX > (double)blockX && entityZ < (double)(blockZ + 1) && entityZ > (double)blockZ) {
                    this.displayNoTeleportMessage(player, state);
                }
                if (state.getValue((Property)WarpPipeBlock.FACING) == Direction.NORTH && !entity.isShiftKeyDown() && entity.getMotionDirection() == Direction.SOUTH && entityX < (double)(blockX + 1) && entityX > (double)blockX && entityY >= (double)blockY && entityY < (double)blockY + 0.75 && entityZ < (double)blockZ) {
                    this.displayNoTeleportMessage(player, state);
                }
                if (state.getValue((Property)WarpPipeBlock.FACING) == Direction.SOUTH && !entity.isShiftKeyDown() && entity.getMotionDirection() == Direction.NORTH && entityX < (double)(blockX + 1) && entityX > (double)blockX && entityY >= (double)blockY && entityY < (double)blockY + 0.75 && entityZ > (double)blockZ + 0.25) {
                    this.displayNoTeleportMessage(player, state);
                }
                if (state.getValue((Property)WarpPipeBlock.FACING) == Direction.EAST && !entity.isShiftKeyDown() && entity.getMotionDirection() == Direction.WEST && entityX > (double)blockX && entityY >= (double)blockY && entityY < (double)blockY + 0.75 && entityZ < (double)(blockZ + 1) && entityZ > (double)blockZ) {
                    this.displayNoTeleportMessage(player, state);
                }
                if (state.getValue((Property)WarpPipeBlock.FACING) != Direction.WEST) return;
                if (entity.isShiftKeyDown()) return;
                if (entity.getMotionDirection() != Direction.EAST) return;
                if (!(entityX < (double)blockX)) return;
                if (!(entityY >= (double)blockY)) return;
                if (!(entityY < (double)blockY + 0.75)) return;
                if (!(entityZ < (double)(blockZ + 1))) return;
                if (!(entityZ > (double)blockZ)) return;
                this.displayNoTeleportMessage(player, state);
                return;
            }
        }
        WP$BlockWarpEntitiesHandler.super.enterWarpPipe(entity, world, pos, warpPos, warpBE);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    default public void enterWarpPipeAbove(Entity entity, Level world, BlockPos pos, BlockPos warpPos, BaseWarpBlockEntity warpBE) {
        BlockState stateAboveEntity = world.getBlockState(pos.above(Math.round(entity.getBbHeight())));
        double entityX = entity.getX();
        double entityZ = entity.getZ();
        int blockX = pos.getX();
        int blockY = pos.getY();
        int blockZ = pos.getZ();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!this.wp$getBlockWarpTeleportConfig() || entity.getType().is(TagRegistry.CANNOT_WARP) || this.wp$doPreventWarp()) {
                if (stateAboveEntity.getValue((Property)WarpPipeBlock.FACING) != Direction.DOWN) return;
                if (entity.getBlockY() >= blockY) return;
                if (!(entityX < (double)(blockX + 1))) return;
                if (!(entityX > (double)blockX)) return;
                if (!(entityZ < (double)(blockZ + 1))) return;
                if (!(entityZ > (double)blockZ)) return;
                this.displayNoTeleportMessage(player, stateAboveEntity);
                return;
            }
        }
        WP$BlockWarpEntitiesHandler.super.enterWarpPipeAbove(entity, world, pos, warpPos, warpBE);
    }

    private void displayNoTeleportMessage(Player player, BlockState state) {
        if ((!this.wp$getBlockWarpTeleportConfig() || player.getType().is(TagRegistry.CANNOT_WARP)) && state.getBlock() instanceof WarpPipeBlock) {
            player.displayClientMessage((Component)Component.translatable((String)"display.warp_pipes.pipes_cannot_teleport_players"), true);
        }
        if (this.wp$doPreventWarp()) {
            player.displayClientMessage((Component)Component.translatable((String)"display.warp_pipes.warp_disrupted_player"), true);
        }
    }
}

