/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.warp_pipes.registries;

import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.ModConfigSpec;

public class ConfigRegistry {
    public static final ConfigRegistry INSTANCE = new ConfigRegistry();
    public static final String CATEGORY_DEBUG = "debug";
    public static final String CATEGORY_CLIENT = "client";
    public static final String CATEGORY_COMMON = "common";
    public static final String CATEGORY_WARP_DISRUPTOR = "warp_disruptor";
    public static final String CATEGORY_WARP_PIPES = "warp_pipes";
    public static final String CATEGORY_WATER_SPOUTS = "water_spouts";
    public static final String CATEGORY_WRENCH = "wrench";
    private final ModConfigSpec CONFIG_SPEC;
    public static ModConfigSpec.BooleanValue ALLOW_FAST_TRAVEL;
    public static ModConfigSpec.BooleanValue ALLOW_PIPE_UNWAXING;
    public static ModConfigSpec.BooleanValue CREATIVE_BUBBLES;
    public static ModConfigSpec.BooleanValue BLINDNESS_EFFECT;
    public static ModConfigSpec.BooleanValue CREATIVE_CLOSE_PIPES;
    public static ModConfigSpec.BooleanValue CREATIVE_WATER_SPOUT;
    public static ModConfigSpec.BooleanValue CREATIVE_WRENCH_LINKING;
    public static ModConfigSpec.BooleanValue DEBUG_PIPE_BUBBLES_SELECTION_BOX;
    public static ModConfigSpec.BooleanValue DEBUG_WATER_SPOUT_SELECTION_BOX;
    public static ModConfigSpec.BooleanValue DEBUG_SELECTION_BOX;
    public static ModConfigSpec.BooleanValue DEBUG_SELECTION_BOX_CREATIVE;
    public static ModConfigSpec.BooleanValue DISABLE_PLAYER_WARP_DISRUPTING;
    public static ModConfigSpec.BooleanValue DISABLE_TEXT;
    public static ModConfigSpec.BooleanValue DISABLE_VANILLA_TABS;
    public static ModConfigSpec.BooleanValue DISABLE_WARP_PIPES_TABS;
    public static ModConfigSpec.BooleanValue TELEPORT_MOBS;
    public static ModConfigSpec.BooleanValue TELEPORT_NON_MOBS;
    public static ModConfigSpec.BooleanValue TELEPORT_PLAYERS;
    public static ModConfigSpec.BooleanValue WARP_COOLDOWN_MESSAGE;
    public static ModConfigSpec.BooleanValue WARP_COOLDOWN_MESSAGE_TICKS;
    public static ModConfigSpec.BooleanValue WARP_PIPE_SPAWNS_MOBS;
    public static ModConfigSpec.BooleanValue WATER_SPOUTS_BUCKETABLE;
    public static ModConfigSpec.BooleanValue WAX_DISABLES_BUBBLES;
    public static ModConfigSpec.BooleanValue WAX_DISABLES_CLOSING;
    public static ModConfigSpec.BooleanValue WAX_DISABLES_RENAMING;
    public static ModConfigSpec.BooleanValue WAX_DISABLES_WARP_LINKING;
    public static ModConfigSpec.BooleanValue WAX_DISABLES_WATER_SPOUTS;
    public static ModConfigSpec.IntValue WARP_COOLDOWN;
    public static ModConfigSpec.IntValue WARP_DISRUPTING_COOLDOWN;

    private ConfigRegistry() {
        ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
        BUILDER.push(CATEGORY_CLIENT);
        DISABLE_TEXT = BUILDER.translation("configuration.warp_pipes.disable_text").comment("Disable text rendering on pipes.").comment("\u00a79[Default: false]").define("disable_text", false);
        WARP_COOLDOWN_MESSAGE = BUILDER.translation("configuration.warp_pipes.warp_cooldown_message").comment("Display a warp cooldown message.").comment("\u00a79[Default: false]").define("warp_cooldown_message", true);
        WARP_COOLDOWN_MESSAGE_TICKS = BUILDER.translation("configuration.warp_pipes.warp_cooldown_message_with_ticks").comment("Display a warp cooldown message with ticks.").comment("\u00a7cRequires \"Warp Cooldown Message\"").comment("\u00a79[Default: false]").define("warp_cooldown_message_with_ticks", false);
        BUILDER.pop();
        BUILDER.push(CATEGORY_COMMON);
        BUILDER.push(CATEGORY_WARP_DISRUPTOR);
        DISABLE_PLAYER_WARP_DISRUPTING = BUILDER.translation("configuration.warp_pipes.disable_player_warp_disrupting").comment("Prevent the Warp Disruptor from working on players.").comment("\u00a79[Default: false]").define("disable_player_warp_disrupting", false);
        WARP_DISRUPTING_COOLDOWN = BUILDER.translation("configuration.warp_pipes.warp_disrupting_cooldown").comment("Cooldown before the player is able to warp again.").comment("\u00a76[20 ticks = 1 second]").comment("\u00a79[Default: 4800]\u00a7b").defineInRange("warp_disrupting_cooldown", 4800, 1, 72000);
        BUILDER.pop();
        BUILDER.push(CATEGORY_WARP_PIPES);
        ALLOW_FAST_TRAVEL = BUILDER.translation("configuration.warp_pipes.allow_fast_travel").comment("Allow fast travel through Clear Warp Pipes.").comment("\u00a79[Default: true]").define("allow_fast_travel", true);
        ALLOW_PIPE_UNWAXING = BUILDER.translation("configuration.warp_pipes.allow_pipe_unwaxing").comment("Allow warp pipes to be unwaxed with an axe.").comment("\u00a79[Default: false]").define("allow_pipe_unwaxing", false);
        BLINDNESS_EFFECT = BUILDER.translation("configuration.warp_pipes.blindness_effect").comment("Warping gives the player a brief blindness effect.").comment("\u00a79[Default: true]").define("blindness_effect", true);
        TELEPORT_MOBS = BUILDER.translation("configuration.warp_pipes.teleport_mobs").comment("Allow mobs to teleport.").comment("\u00a79[Default: true]").define("teleport_mobs", true);
        TELEPORT_NON_MOBS = BUILDER.translation("configuration.warp_pipes.teleport_non_mobs").comment("Allow non-living entities to teleport.").comment("\u00a79[Default: true]").define("teleport_non_mobs", true);
        TELEPORT_PLAYERS = BUILDER.translation("configuration.warp_pipes.teleport_players").comment("Allow players to teleport.").comment("\u00a79[Default: true]").define("teleport_players", true);
        WARP_COOLDOWN = BUILDER.translation("configuration.warp_pipes.warp_cooldown").comment("Cooldown between teleports in ticks.").comment("\u00a76[20 ticks = 1 second]").comment("\u00a79[Default: 50]\u00a7b").defineInRange("warp_cooldown", 50, 0, 72000);
        WARP_PIPE_SPAWNS_MOBS = BUILDER.translation("configuration.warp_pipes.warp_pipe_spawns_mobs").comment("Allow warp pipes to spawn mobs.").comment("\u00a79[Default: true]").define("warp_pipe_spawns_mobs", true);
        WAX_DISABLES_BUBBLES = BUILDER.translation("configuration.warp_pipes.wax_disables_bubbles").comment("Allows waxing pipes to disable the Pipe Bubbles button.").comment("\u00a79[Default: true]").define("wax_disables_bubbles", true);
        WAX_DISABLES_CLOSING = BUILDER.translation("configuration.warp_pipes.wax_disables_closing").comment("Allows waxing pipes to disable the Open/Close button.").comment("\u00a79[Default: true]").define("wax_disables_closing", true);
        WAX_DISABLES_RENAMING = BUILDER.translation("configuration.warp_pipes.wax_disables_renaming").comment("Allows waxing pipes to disable the Rename button.").comment("\u00a79[Default: true]").define("wax_disables_renaming", true);
        WAX_DISABLES_WARP_LINKING = BUILDER.translation("configuration.warp_pipes.wax_disables_warp_linking").comment("Allow waxing warp blocks to disable warp linking.").comment("\u00a79[Default: true]").define("wax_disables_warp_linking", true);
        WAX_DISABLES_WATER_SPOUTS = BUILDER.translation("configuration.warp_pipes.wax_disables_water_spouts").comment("Allows waxing pipes to disable the Water Spout button.").comment("\u00a79[Default: true]").define("wax_disables_water_spouts", true);
        CREATIVE_BUBBLES = BUILDER.translation("configuration.warp_pipes.require_creative_bubbles").comment("Require creative to turn bubbles on/off.").comment("\u00a79[Default: false]").define("require_creative_bubbles", false);
        CREATIVE_CLOSE_PIPES = BUILDER.translation("configuration.warp_pipes.require_creative_close_pipes").comment("Require creative to open/close pipes.").comment("\u00a79[Default: false]").define("require_creative_close_pipes", false);
        CREATIVE_WATER_SPOUT = BUILDER.translation("configuration.warp_pipes.require_creative_water_spouts").comment("Require creative to turn water spouts on/off.").comment("\u00a79[Default: false]").define("require_creative_water_spouts", false);
        BUILDER.pop();
        BUILDER.push(CATEGORY_WATER_SPOUTS);
        WATER_SPOUTS_BUCKETABLE = BUILDER.translation("configuration.warp_pipes.water_spouts_bucketable").comment("Allow players to bucket water spouts.").comment("\u00a79[Default: true]").define("water_spouts_bucketable", true);
        BUILDER.pop();
        BUILDER.push(CATEGORY_WRENCH);
        CREATIVE_WRENCH_LINKING = BUILDER.translation("configuration.warp_pipes.creative_wrench_linking").comment("Require creative to link pipes, doors, trapdoors, & paintings.").comment("\u00a79[Default: false]").define("creative_wrench_linking", false);
        BUILDER.pop();
        DISABLE_WARP_PIPES_TABS = BUILDER.translation("configuration.warp_pipes.disable_warp_pipes_tabs").comment("Disable the Warp Pipes creative tab.").comment("\u00a7cRequires world reload").comment("\u00a79[Default: false]").define("disable_warp_pipes_tabs", false);
        DISABLE_VANILLA_TABS = BUILDER.translation("configuration.warp_pipes.disable_vanilla_tabs").comment("Disable items in vanilla creative tabs.").comment("\u00a7cRequires world reload").comment("\u00a79[Default: false]").define("disable_vanilla_tabs", false);
        BUILDER.pop();
        BUILDER.push(CATEGORY_DEBUG);
        DEBUG_SELECTION_BOX = BUILDER.translation("configuration.warp_pipes.debug_selection_box").comment("Enable debug selection box for Clear Warp Pipes.").comment("\u00a79[Default: false]").define("debug_selection_box", false);
        DEBUG_SELECTION_BOX_CREATIVE = BUILDER.translation("configuration.warp_pipes.debug_selection_box_creative").comment("Enable debug selection box for Clear Warp Pipes in Creative.").comment("\u00a7cCreative Only").comment("\u00a79[Default: true]").define("debug_selection_box_creative", true);
        DEBUG_PIPE_BUBBLES_SELECTION_BOX = BUILDER.translation("configuration.warp_pipes.debug_pipe_bubbles_selection_box").comment("Enable debug selection box for Pipe Bubbles.").comment("\u00a7cCreative Only").comment("\u00a79[Default: false]").define("debug_pipe_bubbles_selection_box", false);
        DEBUG_WATER_SPOUT_SELECTION_BOX = BUILDER.translation("configuration.warp_pipes.debug_water_spout_selection_box").comment("Enable debug selection box for Water Spouts.").comment("\u00a7cCreative Only").comment("\u00a79[Default: false]").define("debug_water_spout_selection_box", false);
        BUILDER.pop();
        this.CONFIG_SPEC = BUILDER.build();
    }

    public static void register(ModContainer container) {
        container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ConfigRegistry.INSTANCE.CONFIG_SPEC, "warp_pipes-common.toml");
    }

    public static void registerClient(ModContainer container) {
        container.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
    }
}

