/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.warp_pipes.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.wenxin2.warp_pipes.blocks.WarpPipeBlock;
import com.wenxin2.warp_pipes.registries.ConfigRegistry;
import com.wenxin2.warp_pipes.registries.ModRegistry;
import com.wenxin2.warp_pipes.registries.TagRegistry;
import com.wenxin2.warp_pipes.utils.WP$BlockWarpEntitiesHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public abstract class EntityMixin
implements WP$BlockWarpEntitiesHandler {
    @Unique
    private boolean wp$preventWarp;
    @Unique
    private int wp$preventWarpCooldown;
    @Unique
    private int wp$warpCooldown;

    @Shadow
    public abstract Level level();

    @Shadow
    public abstract double getX();

    @Shadow
    public abstract double getY();

    @Shadow
    public abstract double getZ();

    @Shadow
    public abstract int getId();

    @Shadow
    public abstract BlockPos blockPosition();

    @Shadow
    public abstract EntityType<?> getType();

    @Shadow
    public abstract void setPos(Vec3 var1);

    @Override
    public boolean wp$getBlockWarpTeleportConfig() {
        return (Boolean)ConfigRegistry.TELEPORT_NON_MOBS.get();
    }

    @Inject(method={"save"}, at={@At(value="TAIL")})
    public void save(CompoundTag tag, CallbackInfoReturnable<Boolean> cir) {
        Entity entity = (Entity)this;
        if (!entity.getType().is(TagRegistry.CANNOT_WARP) && ((Boolean)ConfigRegistry.TELEPORT_NON_MOBS.get()).booleanValue()) {
            tag.putBoolean("marioverse:prevent_warp", this.wp$doPreventWarp());
            tag.putInt("marioverse:warp_cooldown", this.wp$getWarpCooldown());
        }
    }

    @Inject(method={"load"}, at={@At(value="TAIL")})
    public void load(CompoundTag tag, CallbackInfo ci) {
        Entity entity = (Entity)this;
        if (!entity.getType().is(TagRegistry.CANNOT_WARP) && ((Boolean)ConfigRegistry.TELEPORT_NON_MOBS.get()).booleanValue()) {
            this.wp$setPreventWarp(tag.getBoolean("marioverse:prevent_warp"));
            this.wp$setWarpCooldown(tag.getInt("marioverse:warp_cooldown"));
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"tick"})
    public void tick(CallbackInfo ci) {
        Entity entity = (Entity)this;
        Level world = entity.level();
        BlockPos pos = entity.blockPosition();
        BlockPos posAboveEntity = pos.above(Math.round(entity.getBbHeight()));
        BlockState state = world.getBlockState(pos);
        BlockState stateAboveEntity = world.getBlockState(posAboveEntity);
        if (this.wp$getWarpCooldown() > 0) {
            this.wp$setWarpCooldown(this.wp$getWarpCooldown() - 1);
        }
        for (Direction facing : Direction.values()) {
            BlockPos offsetPos = pos.relative(facing);
            BlockState offsetState = world.getBlockState(offsetPos);
            if (this.wp$doPreventWarp() && !(entity instanceof Player)) continue;
            if (offsetState.getBlock() instanceof WarpPipeBlock && !((Boolean)offsetState.getValue((Property)WarpPipeBlock.CLOSED)).booleanValue()) {
                this.enterWarp(entity, world, offsetPos);
            }
            if (!(state.getBlock() instanceof WarpPipeBlock) || ((Boolean)state.getValue((Property)WarpPipeBlock.CLOSED)).booleanValue()) continue;
            this.enterWarp(entity, world, pos);
        }
        if (stateAboveEntity.getBlock() instanceof WarpPipeBlock && !((Boolean)stateAboveEntity.getValue((Property)WarpPipeBlock.CLOSED)).booleanValue() && !this.wp$doPreventWarp()) {
            this.enterWarp(entity, world, pos);
        }
    }

    @ModifyReturnValue(method={"isInWaterOrBubble"}, at={@At(value="RETURN")})
    private boolean isInWaterOrBubble(boolean original) {
        BlockState state = this.level().getBlockState(this.blockPosition());
        if (!original && state.is((Block)ModRegistry.PIPE_BUBBLES.get())) {
            return true;
        }
        return original;
    }

    @ModifyReturnValue(method={"isInWaterRainOrBubble"}, at={@At(value="RETURN")})
    private boolean isInWaterRainOrBubble(boolean original) {
        BlockState state = this.level().getBlockState(this.blockPosition());
        if (!original && state.is((Block)ModRegistry.PIPE_BUBBLES.get())) {
            return true;
        }
        return original;
    }

    @Override
    public boolean wp$doPreventWarp() {
        return this.wp$preventWarp;
    }

    @Override
    public void wp$setPreventWarp(boolean preventWarp) {
        this.wp$preventWarp = preventWarp;
    }

    @Override
    public int wp$getPreventWarpCooldown() {
        return this.wp$preventWarpCooldown;
    }

    @Override
    public void wp$setPreventWarpCooldown(int preventWarpCooldown) {
        this.wp$preventWarpCooldown = preventWarpCooldown;
    }

    @Override
    public int wp$getWarpCooldown() {
        return this.wp$warpCooldown;
    }

    @Override
    public void wp$setWarpCooldown(int warpCooldown) {
        this.wp$warpCooldown = warpCooldown;
    }

    @Inject(method={"handleEntityEvent"}, at={@At(value="HEAD")})
    private void handleEntityEvent(byte id, CallbackInfo ci) {
        Entity entity = (Entity)this;
        RandomSource random = entity.getRandom();
        if (id == 120) {
            for (int i = 0; i < 100; ++i) {
                this.level().addParticle((ParticleOptions)ParticleTypes.ENCHANT, entity.getRandomX(0.5), entity.getRandomY(), entity.getRandomZ(0.5), (random.nextDouble() - 0.5) * 2.0, -random.nextDouble(), (random.nextDouble() - 0.5) * 2.0);
            }
        }
    }
}

