/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.warp_pipes.datagen;

import com.wenxin2.warp_pipes.datagen.RecipeUtils;
import com.wenxin2.warp_pipes.registries.ModRegistry;
import com.wenxin2.warp_pipes.registries.TagRegistry;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.registries.DeferredBlock;

public class RecipeGen
extends RecipeUtils {
    public RecipeGen(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(output, lookupProvider);
    }

    protected void buildRecipes(RecipeOutput output) {
        RecipeGen.oneToOneConversionRecipe((RecipeOutput)output, ModRegistry.WRENCH, ModRegistry.WRENCH, (String)("warp_pipes:" + RecipeGen.getSimpleRecipeName(ModRegistry.WRENCH)));
        this.twoItemTagRecipe(1, "warp_pipes", "_from_glass", (ItemLike)ModRegistry.CLEAR_WARP_PIPE, RecipeCategory.BUILDING_BLOCKS, TagRegistry.DYEABLE_WARP_PIPE_ITEMS, (TagKey<Item>)Tags.Items.GLASS_BLOCKS_COLORLESS, output);
        this.warpDisruptorRecipe(1, (ItemLike)ModRegistry.WARP_DISRUPTOR, (ItemLike)Items.ENDER_EYE, (TagKey<Item>)Tags.Items.INGOTS_GOLD, (TagKey<Item>)Tags.Items.RODS_WOODEN, output);
        this.warpPipeRecipe(4, (ItemLike)ModRegistry.CLEAR_WARP_PIPE, (TagKey<Item>)Tags.Items.INGOTS_COPPER, (TagKey<Item>)Tags.Items.GLASS_BLOCKS_COLORLESS, (TagKey<Item>)Tags.Items.GEMS_DIAMOND, (TagKey<Item>)Tags.Items.ENDER_PEARLS, output);
        this.wrenchRecipe(1, (ItemLike)ModRegistry.WRENCH, (TagKey<Item>)Tags.Items.INGOTS_IRON, output);
        for (Map.Entry<DyeColor, DeferredBlock<Block>> entry : ModRegistry.WARP_PIPES.entrySet()) {
            DyeColor dyeColor = entry.getKey();
            TagKey<Item> dyeItemTag = TagRegistry.itemTags("c", "dyes/" + dyeColor.getName());
            this.warpPipeRecipe(4, (ItemLike)entry.getValue(), (TagKey<Item>)Tags.Items.INGOTS_COPPER, dyeItemTag, (TagKey<Item>)Tags.Items.GEMS_DIAMOND, (TagKey<Item>)Tags.Items.ENDER_PEARLS, output);
            this.dyeItemRecipe(1, "warp_pipes_from_dye", (ItemLike)entry.getValue(), RecipeCategory.BUILDING_BLOCKS, dyeItemTag, TagRegistry.DYEABLE_WARP_PIPE_ITEMS, output);
        }
    }
}

