/*
 * Decompiled with CFR 0.152.
 */
package com.wenxin2.warp_pipes;

import com.wenxin2.warp_pipes.registries.ConfigRegistry;
import com.wenxin2.warp_pipes.registries.ModRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber(modid="warp_pipes")
public class WarpPipesCreativeTabs {
    public static final DeferredRegister<CreativeModeTab> TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"warp_pipes");
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> WARP_PIPES_TAB = TABS.register("warp_pipes_tab", () -> CreativeModeTab.builder().title((Component)Component.translatable((String)"itemGroup.warp_pipes")).icon(() -> new ItemStack((ItemLike)ModRegistry.WARP_PIPES.get(DyeColor.GREEN).get())).build());

    @SubscribeEvent
    public static void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == WARP_PIPES_TAB.getKey() && !((Boolean)ConfigRegistry.DISABLE_WARP_PIPES_TABS.get()).booleanValue()) {
            WarpPipesCreativeTabs.add(event, (ItemLike)ModRegistry.WRENCH.get());
            WarpPipesCreativeTabs.add(event, ModRegistry.WARP_DISRUPTOR);
            WarpPipesCreativeTabs.add(event, (ItemLike)ModRegistry.CLEAR_WARP_PIPE.get());
            WarpPipesCreativeTabs.addDyedBlocks(event, ModRegistry.CLEAR_WARP_PIPE, ModRegistry.WARP_PIPES, true, true);
        }
        if (!((Boolean)ConfigRegistry.DISABLE_VANILLA_TABS.get()).booleanValue()) {
            if (event.getTabKey() == CreativeModeTabs.TOOLS_AND_UTILITIES) {
                WarpPipesCreativeTabs.addAfter(event, (ItemLike)Items.FISHING_ROD, (ItemLike)ModRegistry.WRENCH.get());
                WarpPipesCreativeTabs.addBefore(event, ModRegistry.WRENCH, ModRegistry.WARP_DISRUPTOR);
            }
            if (event.getTabKey() == CreativeModeTabs.COMBAT) {
                WarpPipesCreativeTabs.addBefore(event, (ItemLike)Items.SHIELD, (ItemLike)ModRegistry.WRENCH.get());
            }
            if (event.getTabKey() == CreativeModeTabs.REDSTONE_BLOCKS) {
                WarpPipesCreativeTabs.addAfter(event, (ItemLike)Items.REDSTONE_LAMP, (ItemLike)ModRegistry.CLEAR_WARP_PIPE.get());
                WarpPipesCreativeTabs.addAfter(event, (ItemLike)Items.REDSTONE_LAMP, (ItemLike)ModRegistry.WARP_PIPES.get(DyeColor.GREEN).get());
            }
            if (event.getTabKey() == CreativeModeTabs.COLORED_BLOCKS) {
                WarpPipesCreativeTabs.addAfter(event, (ItemLike)Blocks.PINK_SHULKER_BOX, ModRegistry.CLEAR_WARP_PIPE);
                WarpPipesCreativeTabs.addDyedBlocks(event, ModRegistry.CLEAR_WARP_PIPE, ModRegistry.WARP_PIPES, true, true);
            }
            if (event.getTabKey() == CreativeModeTabs.FUNCTIONAL_BLOCKS) {
                WarpPipesCreativeTabs.addAfter(event, (ItemLike)Items.RESPAWN_ANCHOR, ModRegistry.CLEAR_WARP_PIPE);
                WarpPipesCreativeTabs.addDyedBlocks(event, ModRegistry.CLEAR_WARP_PIPE, ModRegistry.WARP_PIPES, true, true);
            }
        }
    }

    public static void add(BuildCreativeModeTabContentsEvent event, ItemLike item) {
        ItemStack stack = new ItemStack(item);
        WarpPipesCreativeTabs.add(event, stack);
    }

    public static void add(BuildCreativeModeTabContentsEvent event, ItemStack stack) {
        if (stack.isEmpty()) {
            System.out.println("Warning, attempting to register an empty stack to tab!");
            return;
        }
        event.accept(stack);
    }

    public static void addAfter(BuildCreativeModeTabContentsEvent event, ItemLike afterItem, ItemLike item) {
        event.insertAfter(new ItemStack(afterItem), new ItemStack(item), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
    }

    public static void addBefore(BuildCreativeModeTabContentsEvent event, ItemLike beforeItem, ItemLike item) {
        event.insertBefore(new ItemStack(beforeItem), new ItemStack(item), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
    }

    /*
     * WARNING - void declaration
     */
    private static void addDyedBlocks(BuildCreativeModeTabContentsEvent event, ItemLike existingItem, EnumMap<DyeColor, DeferredBlock<Block>> dyedBlock, boolean isReversed, boolean addAfter) {
        List<DyeColor> rainbowOrder = Arrays.asList(DyeColor.WHITE, DyeColor.LIGHT_GRAY, DyeColor.GRAY, DyeColor.BLACK, DyeColor.BROWN, DyeColor.RED, DyeColor.ORANGE, DyeColor.YELLOW, DyeColor.LIME, DyeColor.GREEN, DyeColor.CYAN, DyeColor.LIGHT_BLUE, DyeColor.BLUE, DyeColor.PURPLE, DyeColor.MAGENTA, DyeColor.PINK);
        ArrayList<DeferredBlock<Block>> dyedBlocks = new ArrayList<DeferredBlock<Block>>();
        HashSet<DyeColor> processedColors = new HashSet<DyeColor>();
        if (isReversed) {
            Collections.reverse(rainbowOrder);
        }
        for (DyeColor dyeColor : rainbowOrder) {
            DeferredBlock<Block> deferredBlock = dyedBlock.get(dyeColor);
            if (deferredBlock == null) continue;
            dyedBlocks.add(deferredBlock);
            processedColors.add(dyeColor);
        }
        HashSet<Block> additionalBlocks = new HashSet<Block>();
        for (Map.Entry<DyeColor, DeferredBlock<Block>> entry : dyedBlock.entrySet()) {
            DyeColor color = entry.getKey();
            if (processedColors.contains(color)) continue;
            additionalBlocks.add((Block)entry.getValue().get());
        }
        HashSet<Block> hashSet = new HashSet<Block>();
        Object var10_15 = null;
        for (DeferredHolder deferredHolder : dyedBlocks) {
            Block coloredBlock = (Block)deferredHolder.get();
            if (hashSet.contains(coloredBlock)) continue;
            if (addAfter) {
                WarpPipesCreativeTabs.addAfter(event, existingItem, (ItemLike)coloredBlock);
            } else {
                WarpPipesCreativeTabs.addBefore(event, existingItem, (ItemLike)coloredBlock);
            }
            hashSet.add(coloredBlock);
            Block block = (Block)dyedBlock.get(DyeColor.PINK).get();
        }
        for (Block block : additionalBlocks) {
            void var10_16;
            if (hashSet.contains(block)) continue;
            if (var10_16 != null && addAfter) {
                WarpPipesCreativeTabs.addAfter(event, (ItemLike)var10_16, (ItemLike)block);
            } else {
                WarpPipesCreativeTabs.addBefore(event, existingItem, (ItemLike)block);
            }
            hashSet.add(block);
        }
    }
}

