/*
 * Decompiled with CFR 0.152.
 */
package dev.uncandango.kubejstweaks.impl;

import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.CloseableResourceManager;
import net.minecraft.server.packs.resources.FallbackResourceManager;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceFilterSection;
import net.minecraft.server.packs.resources.ResourceManager;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.data.loading.DatagenModLoader;
import org.slf4j.Logger;

public class TempResourceManager
implements CloseableResourceManager {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Map<String, FallbackResourceManager> namespacedManagers;
    private final List<PackResources> packs;

    public TempResourceManager(PackType type, List<PackResources> packs) {
        this.packs = TempResourceManager.filterIncompatiblePacks(packs);
        HashMap<String, FallbackResourceManager> map = new HashMap<String, FallbackResourceManager>();
        List list = this.packs.stream().flatMap(p_215471_ -> p_215471_.getNamespaces(type).stream()).distinct().toList();
        for (PackResources packresources : this.packs) {
            ResourceFilterSection resourcefiltersection = this.getPackFilterSection(packresources);
            Set set = packresources.getNamespaces(type);
            Predicate<ResourceLocation> predicate = resourcefiltersection != null ? p_215474_ -> resourcefiltersection.isPathFiltered(p_215474_.getPath()) : null;
            for (String s : list) {
                boolean flag1;
                boolean flag = set.contains(s);
                boolean bl = flag1 = resourcefiltersection != null && resourcefiltersection.isNamespaceFiltered(s);
                if (!flag && !flag1) continue;
                FallbackResourceManager fallbackresourcemanager = (FallbackResourceManager)map.get(s);
                if (fallbackresourcemanager == null) {
                    fallbackresourcemanager = new FallbackResourceManager(type, s);
                    map.put(s, fallbackresourcemanager);
                }
                if (flag && flag1) {
                    fallbackresourcemanager.push(packresources, predicate);
                    continue;
                }
                if (flag) {
                    fallbackresourcemanager.push(packresources);
                    continue;
                }
                fallbackresourcemanager.pushFilterOnly(packresources.packId(), predicate);
            }
        }
        this.namespacedManagers = map;
    }

    private static List<PackResources> filterIncompatiblePacks(List<PackResources> packs) {
        HashSet<String> packsToSkip = new HashSet<String>();
        if (ModList.get().isLoaded("dynamic_asset_generator")) {
            packsToSkip.addAll(Set.of("mod/dynamic_asset_generator", "dynamic_asset_generator/dynamic_asset_generator:builtin_assets", "dynamic_asset_generator/dynamic_asset_generator:builtin_data", "dynamic_asset_generator/buddingcrystals:assets"));
        }
        if (ModList.get().isLoaded("buddingcrystals")) {
            packsToSkip.add("mod/buddingcrystals");
        }
        if (ModList.get().isLoaded("supplementaries")) {
            packsToSkip.add("mod/supplementaries");
            packsToSkip.add("supplementaries:generated_pack");
        }
        if (ModList.get().isLoaded("moonlight")) {
            packsToSkip.add("mod/moonlight");
            packsToSkip.add("moonlight:merged_pack");
        }
        if (ModList.get().isLoaded("sawmill")) {
            packsToSkip.add("mod/sawmill");
            packsToSkip.add("sawmill:sawmill_recipes");
        }
        return packs.stream().filter(pack -> !packsToSkip.contains(pack.packId())).toList();
    }

    @Nullable
    private ResourceFilterSection getPackFilterSection(PackResources packResources) {
        try {
            return (ResourceFilterSection)packResources.getMetadataSection((MetadataSectionSerializer)ResourceFilterSection.TYPE);
        }
        catch (IOException ioexception) {
            if (!DatagenModLoader.isRunningDataGen()) {
                LOGGER.error("Failed to get filter section from pack {}", (Object)packResources.packId());
            }
            return null;
        }
    }

    public Set<String> getNamespaces() {
        return this.namespacedManagers.keySet();
    }

    public Optional<Resource> getResource(ResourceLocation location) {
        ResourceManager resourcemanager = (ResourceManager)this.namespacedManagers.get(location.getNamespace());
        return resourcemanager != null ? resourcemanager.getResource(location) : Optional.empty();
    }

    public List<Resource> getResourceStack(ResourceLocation location) {
        ResourceManager resourcemanager = (ResourceManager)this.namespacedManagers.get(location.getNamespace());
        return resourcemanager != null ? resourcemanager.getResourceStack(location) : List.of();
    }

    public Map<ResourceLocation, Resource> listResources(String path, Predicate<ResourceLocation> filter) {
        TempResourceManager.checkTrailingDirectoryPath(path);
        TreeMap<ResourceLocation, Resource> map = new TreeMap<ResourceLocation, Resource>();
        for (FallbackResourceManager fallbackresourcemanager : this.namespacedManagers.values()) {
            map.putAll(fallbackresourcemanager.listResources(path, filter));
        }
        return map;
    }

    public Map<ResourceLocation, List<Resource>> listResourceStacks(String path, Predicate<ResourceLocation> filter) {
        TempResourceManager.checkTrailingDirectoryPath(path);
        TreeMap<ResourceLocation, List<Resource>> map = new TreeMap<ResourceLocation, List<Resource>>();
        for (FallbackResourceManager fallbackresourcemanager : this.namespacedManagers.values()) {
            map.putAll(fallbackresourcemanager.listResourceStacks(path, filter));
        }
        return map;
    }

    private static void checkTrailingDirectoryPath(String path) {
        if (path.endsWith("/")) {
            throw new IllegalArgumentException("Trailing slash in path " + path);
        }
    }

    public Stream<PackResources> listPacks() {
        return this.packs.stream();
    }

    public void close() {
        this.packs.forEach(PackResources::close);
    }
}

