/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.flightblocks.block.entity;

import com.benbenlaw.flightblocks.block.entity.FlightBlockEntities;
import com.benbenlaw.flightblocks.config.StartupConfig;
import com.benbenlaw.flightblocks.event.FlightBlockEventHandler;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class FlightBlockEntity
extends BlockEntity {
    public static final int RANGE = (Integer)StartupConfig.flightBlockRange.get();
    private final Set<ServerPlayer> enabledPlayers = new HashSet<ServerPlayer>();
    public static final Set<FlightBlockEntity> ACTIVE_BLOCKS = new HashSet<FlightBlockEntity>();
    private boolean showRange = false;

    public FlightBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)FlightBlockEntities.FLIGHT_BLOCK_ENTITY.get(), pos, state);
        ACTIVE_BLOCKS.add(this);
    }

    public void tick() {
        assert (this.level != null);
        if (!this.level.isClientSide() && this.showRange) {
            ServerLevel serverLevel = (ServerLevel)this.level;
            if (this.level.getGameTime() % 40L == 0L) {
                for (ServerPlayer player : FlightBlockEventHandler.playersWithFlightEnabled) {
                    this.showFlightRangeOutline(serverLevel, player);
                }
            }
        }
    }

    public void setRemoved() {
        super.setRemoved();
        ACTIVE_BLOCKS.remove((Object)this);
    }

    public void onRightClick(ServerPlayer player) {
        if (this.showRange) {
            this.showRange = false;
            Level level = this.getLevel();
            if (level != null && !level.isClientSide()) {
                this.showFlightRangeOutline((ServerLevel)level, player);
            }
        } else {
            this.showRange = true;
            player.sendSystemMessage((Component)Component.translatable((String)"block.flightblocks.flight_block.range", (Object[])new Object[]{RANGE}));
        }
    }

    private void showFlightRangeOutline(ServerLevel level, ServerPlayer player) {
        AABB range = new AABB(this.worldPosition).inflate((double)RANGE, (double)RANGE, (double)RANGE);
        int minX = (int)Math.floor(range.minX);
        int minY = (int)Math.floor(range.minY);
        int minZ = (int)Math.floor(range.minZ);
        int maxX = (int)Math.ceil(range.maxX);
        int maxY = (int)Math.ceil(range.maxY);
        int maxZ = (int)Math.ceil(range.maxZ);
        int step = 1;
        for (int x = minX; x <= maxX; x += step) {
            this.spawnParticle(level, player, (double)x + 0.5, (double)minY + 0.5, (double)minZ + 0.5);
            this.spawnParticle(level, player, (double)x + 0.5, (double)minY + 0.5, (double)maxZ + 0.5);
            this.spawnParticle(level, player, (double)x + 0.5, (double)maxY + 0.5, (double)minZ + 0.5);
            this.spawnParticle(level, player, (double)x + 0.5, (double)maxY + 0.5, (double)maxZ + 0.5);
        }
        for (int y = minY; y <= maxY; y += step) {
            this.spawnParticle(level, player, (double)minX + 0.5, (double)y + 0.5, (double)minZ + 0.5);
            this.spawnParticle(level, player, (double)minX + 0.5, (double)y + 0.5, (double)maxZ + 0.5);
            this.spawnParticle(level, player, (double)maxX + 0.5, (double)y + 0.5, (double)minZ + 0.5);
            this.spawnParticle(level, player, (double)maxX + 0.5, (double)y + 0.5, (double)maxZ + 0.5);
        }
        for (int z = minZ; z <= maxZ; z += step) {
            this.spawnParticle(level, player, (double)minX + 0.5, (double)minY + 0.5, (double)z + 0.5);
            this.spawnParticle(level, player, (double)minX + 0.5, (double)maxY + 0.5, (double)z + 0.5);
            this.spawnParticle(level, player, (double)maxX + 0.5, (double)minY + 0.5, (double)z + 0.5);
            this.spawnParticle(level, player, (double)maxX + 0.5, (double)maxY + 0.5, (double)z + 0.5);
        }
    }

    private void spawnParticle(ServerLevel level, ServerPlayer player, double x, double y, double z) {
        level.sendParticles(player, (ParticleOptions)ParticleTypes.END_ROD, true, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
    }

    private void showFlightRange(ServerLevel level, ServerPlayer player) {
        AABB range = new AABB(this.worldPosition).inflate((double)RANGE, (double)RANGE, (double)RANGE);
        double minX = range.minX;
        double minY = range.minY;
        double minZ = range.minZ;
        double maxX = range.maxX;
        double maxY = range.maxY;
        double maxZ = range.maxZ;
        for (double x = minX; x < maxX; x += 1.0) {
            for (double y = minY; y < maxY; y += 1.0) {
                for (double z = minZ; z < maxZ; z += 1.0) {
                    if (x != minX && x != maxX - 1.0 && y != minY && y != maxY - 1.0 && z != minZ && z != maxZ - 1.0) continue;
                    level.sendParticles(player, (ParticleOptions)ParticleTypes.END_ROD, true, x + 0.5, y + 0.5, z + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    protected void saveAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.saveAdditional(compoundTag, provider);
        compoundTag.putBoolean("showRange", this.showRange);
    }

    protected void loadAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        this.showRange = compoundTag.getBoolean("showRange");
        super.loadAdditional(compoundTag, provider);
    }
}

