/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.impl.component.config;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.Applicative;
import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.api.component.ISideConfigComponent;
import fr.frinn.custommachinery.common.util.Color;
import fr.frinn.custommachinery.impl.codec.EnumMapCodec;
import fr.frinn.custommachinery.impl.component.config.RelativeSide;
import fr.frinn.custommachinery.impl.component.config.SideConfig;
import fr.frinn.custommachinery.impl.component.config.ToggleSideMode;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class ToggleSideConfig
extends SideConfig<ToggleSideMode> {
    public ToggleSideConfig(ISideConfigComponent component, Map<RelativeSide, ToggleSideMode> defaultConfig, boolean enabled, Color color) {
        super(component, defaultConfig, enabled, color);
    }

    @Override
    public void setNext(RelativeSide side) {
        this.setSideMode(side, this.getSideMode(side) == ToggleSideMode.ENABLED ? ToggleSideMode.DISABLED : ToggleSideMode.ENABLED);
    }

    @Override
    public void setPrevious(RelativeSide side) {
        this.setSideMode(side, this.getSideMode(side) == ToggleSideMode.ENABLED ? ToggleSideMode.DISABLED : ToggleSideMode.ENABLED);
    }

    public ToggleSideConfig copy() {
        return new ToggleSideConfig(this.getComponent(), this.sides, this.isEnabled(), this.getColor());
    }

    @Override
    public CompoundTag serialize() {
        CompoundTag nbt = new CompoundTag();
        this.sides.forEach((side, mode) -> nbt.put(side.name(), (Tag)ByteTag.valueOf((boolean)mode.isEnabled())));
        return nbt;
    }

    @Override
    public void deserialize(CompoundTag nbt) {
        for (RelativeSide side : RelativeSide.values()) {
            Tag tag = nbt.get(side.name());
            if (!(tag instanceof ByteTag)) continue;
            ByteTag byteTag = (ByteTag)tag;
            this.sides.put(side, byteTag == ByteTag.ONE ? ToggleSideMode.ENABLED : ToggleSideMode.DISABLED);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ToggleSideConfig) {
            ToggleSideConfig config = (ToggleSideConfig)obj;
            for (RelativeSide side : RelativeSide.values()) {
                if (config.getSideMode(side) == this.getSideMode(side)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public record Template(Map<RelativeSide, ToggleSideMode> sides, boolean enabled, Color color) implements SideConfig.Template<ToggleSideMode>
    {
        public static final NamedCodec<Template> CODEC = NamedCodec.record(templateInstance -> templateInstance.group(EnumMapCodec.of(RelativeSide.class, ToggleSideMode.CODEC, ToggleSideMode.ENABLED).forGetter(template -> template.sides), NamedCodec.BOOL.optionalFieldOf("enabled", true).forGetter(Template::enabled), Color.CODEC.optionalFieldOf("color", SideConfig.DEFAULT_COLOR).forGetter(Template::color)).apply((Applicative)templateInstance, Template::new), "Toggle Side Config Template");
        public static final Template DEFAULT_ALL_ENABLED = Template.makeDefault(ToggleSideMode.ENABLED, true);
        public static final Template DEFAULT_ALL_DISABLED = Template.makeDefault(ToggleSideMode.DISABLED, true);
        public static final Template DEFAULT_ALL_DISABLED_DISABLED = Template.makeDefault(ToggleSideMode.DISABLED, false);

        private static Template makeDefault(ToggleSideMode defaultMode, boolean enabled) {
            EnumMap map = Maps.newEnumMap(RelativeSide.class);
            for (RelativeSide side : RelativeSide.values()) {
                map.put(side, defaultMode);
            }
            return new Template(map, enabled, SideConfig.DEFAULT_COLOR);
        }

        public <T extends ISideConfigComponent> ToggleSideConfig build(T component) {
            return new ToggleSideConfig((ISideConfigComponent)component, this.sides, this.enabled, this.color);
        }
    }
}

