/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.network;

import com.mojang.datafixers.util.Pair;
import fr.frinn.custommachinery.CustomMachinery;
import fr.frinn.custommachinery.client.ClientPacketHandler;
import fr.frinn.custommachinery.common.machine.CustomMachine;
import fr.frinn.custommachinery.common.machine.MachineLocation;
import fr.frinn.custommachinery.common.machine.UpgradedCustomMachine;
import fr.frinn.custommachinery.common.util.Comparators;
import fr.frinn.custommachinery.impl.util.TextComponentUtils;
import io.netty.handler.codec.EncoderException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record SUpdateTemplatesPacket(Map<ResourceLocation, Pair<CustomMachine, Component>> templates) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SUpdateTemplatesPacket> TYPE = new CustomPacketPayload.Type(CustomMachinery.rl("update_templates"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SUpdateTemplatesPacket> CODEC = new StreamCodec<RegistryFriendlyByteBuf, SUpdateTemplatesPacket>(){

        public SUpdateTemplatesPacket decode(RegistryFriendlyByteBuf buf) {
            HashMap<ResourceLocation, Pair<CustomMachine, Component>> map = new HashMap<ResourceLocation, Pair<CustomMachine, Component>>();
            int size = buf.readInt();
            for (int i = 0; i < size; ++i) {
                try {
                    CustomMachine machine;
                    MachineLocation location = MachineLocation.CODEC.fromNetwork((FriendlyByteBuf)buf);
                    if (buf.readBoolean()) {
                        ResourceLocation parent = buf.readResourceLocation();
                        machine = UpgradedCustomMachine.makeCodec((CustomMachine)((Pair)map.get(parent)).getFirst()).fromNetwork((FriendlyByteBuf)buf);
                    } else {
                        machine = CustomMachine.CODEC.fromNetwork((FriendlyByteBuf)buf);
                    }
                    machine.setLocation(location);
                    Component tooltip = TextComponentUtils.CODEC.fromNetwork((FriendlyByteBuf)buf);
                    map.put(location.id(), (Pair<CustomMachine, Component>)Pair.of((Object)machine, (Object)tooltip));
                    continue;
                }
                catch (EncoderException e) {
                    e.printStackTrace();
                }
            }
            return new SUpdateTemplatesPacket(map);
        }

        public void encode(RegistryFriendlyByteBuf buf, SUpdateTemplatesPacket packet) {
            buf.writeInt(packet.templates.size());
            packet.templates.values().stream().map(Pair::getFirst).sorted(Comparators.PARENT_MACHINE_FIRST).forEach(machine -> {
                try {
                    MachineLocation.CODEC.toNetwork(machine.getLocation(), (FriendlyByteBuf)buf);
                    if (machine instanceof UpgradedCustomMachine) {
                        UpgradedCustomMachine upgradedMachine = (UpgradedCustomMachine)machine;
                        buf.writeBoolean(true);
                        buf.writeResourceLocation(((UpgradedCustomMachine)machine).getParentId());
                        UpgradedCustomMachine.makeCodec((CustomMachine)packet.templates.get(upgradedMachine.getParentId()).getFirst()).toNetwork(upgradedMachine, (FriendlyByteBuf)buf);
                        TextComponentUtils.CODEC.toNetwork((Component)packet.templates.get(machine.getId()).getSecond(), (FriendlyByteBuf)buf);
                    } else {
                        buf.writeBoolean(false);
                        CustomMachine.CODEC.toNetwork((CustomMachine)machine, (FriendlyByteBuf)buf);
                        TextComponentUtils.CODEC.toNetwork((Component)packet.templates.get(machine.getId()).getSecond(), (FriendlyByteBuf)buf);
                    }
                }
                catch (EncoderException e) {
                    e.printStackTrace();
                }
            });
        }
    };

    public CustomPacketPayload.Type<SUpdateTemplatesPacket> type() {
        return TYPE;
    }

    public static void handle(SUpdateTemplatesPacket packet, IPayloadContext context) {
        if (context.flow().isClientbound()) {
            context.enqueueWork(() -> ClientPacketHandler.handleUpdateTemplatesPacket(packet.templates));
        }
    }
}

