/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.network;

import fr.frinn.custommachinery.CustomMachinery;
import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.requirement.StructureRequirement;
import fr.frinn.custommachinery.common.util.BlockIngredient;
import fr.frinn.custommachinery.common.util.BlockStructure;
import fr.frinn.custommachinery.common.util.MachineList;
import fr.frinn.custommachinery.impl.codec.DefaultCodecs;
import java.util.List;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record CPlaceStructurePacket(ResourceLocation machine, List<List<String>> pattern, Map<Character, List<BlockIngredient>> keys) implements CustomPacketPayload
{
    public static final NamedCodec<List<List<String>>> PATTERN_CODEC = NamedCodec.STRING.forcedListOf().forcedListOf();
    public static final NamedCodec<Map<Character, List<BlockIngredient>>> KEYS_CODEC = NamedCodec.unboundedMap(DefaultCodecs.CHARACTER, BlockIngredient.CODEC.listOf(), "Structure keys");
    public static final CustomPacketPayload.Type<CPlaceStructurePacket> TYPE = new CustomPacketPayload.Type(CustomMachinery.rl("place_structure"));
    public static final StreamCodec<RegistryFriendlyByteBuf, CPlaceStructurePacket> CODEC = new StreamCodec<RegistryFriendlyByteBuf, CPlaceStructurePacket>(){

        public CPlaceStructurePacket decode(RegistryFriendlyByteBuf buf) {
            return new CPlaceStructurePacket(buf.readResourceLocation(), PATTERN_CODEC.fromNetwork((FriendlyByteBuf)buf), KEYS_CODEC.fromNetwork((FriendlyByteBuf)buf));
        }

        public void encode(RegistryFriendlyByteBuf buf, CPlaceStructurePacket packet) {
            buf.writeResourceLocation(packet.machine);
            PATTERN_CODEC.toNetwork(packet.pattern, (FriendlyByteBuf)buf);
            KEYS_CODEC.toNetwork(packet.keys, (FriendlyByteBuf)buf);
        }
    };

    public CustomPacketPayload.Type<CPlaceStructurePacket> type() {
        return TYPE;
    }

    public static void handle(CPlaceStructurePacket packet, IPayloadContext context) {
        Player player = context.player();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            if (player2.getAbilities().instabuild) {
                context.enqueueWork(() -> MachineList.findNearest((Player)player2, packet.machine, 20).flatMap(tile -> tile.getComponentManager().getComponent(Registration.STRUCTURE_MACHINE_COMPONENT.get())).ifPresent(component -> {
                    BlockStructure structure = StructureRequirement.makeStructure(packet.pattern, packet.keys);
                    component.placeStructure(structure, false);
                }));
            }
        }
    }
}

