/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.machine;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.JsonOps;
import fr.frinn.custommachinery.CustomMachinery;
import fr.frinn.custommachinery.api.ICustomMachineryAPI;
import fr.frinn.custommachinery.common.machine.CustomMachine;
import fr.frinn.custommachinery.common.machine.MachineLocation;
import fr.frinn.custommachinery.common.machine.UpgradedCustomMachine;
import fr.frinn.custommachinery.common.requirement.FunctionRequirement;
import fr.frinn.custommachinery.common.util.CustomJsonReloadListener;
import fr.frinn.custommachinery.common.util.MachineList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.ResourceLocationException;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import oshi.util.tuples.Triplet;

public class CustomMachineJsonReloadListener
extends CustomJsonReloadListener {
    private static final String MAIN_PACKNAME = "main";
    public static ICondition.IContext context;

    public CustomMachineJsonReloadListener() {
        super("machine", "machines");
    }

    protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager resourceManager, ProfilerFiller profiler) {
        ICustomMachineryAPI.INSTANCE.logger().info("Reading Custom Machinery Machines...");
        CustomMachinery.MACHINES.clear();
        context = this.getContext();
        ArrayList upgradedMachines = new ArrayList();
        map.forEach((id, json) -> {
            MachineLocation location = this.getMachineLocation(resourceManager, (ResourceLocation)id);
            ICustomMachineryAPI.INSTANCE.logger().info("Parsing machine json: {} in datapack: {}", id, (Object)location.packName());
            if (!json.isJsonObject()) {
                ICustomMachineryAPI.INSTANCE.logger().error("Bad machine JSON: {} must be a json object and not an array or primitive, skipping...", id);
                return;
            }
            JsonObject jsonObject = (JsonObject)json;
            if (CustomMachinery.MACHINES.containsKey(id)) {
                ICustomMachineryAPI.INSTANCE.logger().error("A machine with id: {} already exists, skipping...", id);
                return;
            }
            if (jsonObject.has("parent") && jsonObject.get("parent").isJsonPrimitive() && jsonObject.getAsJsonPrimitive("parent").isString()) {
                String parent = jsonObject.getAsJsonPrimitive("parent").getAsString();
                try {
                    ResourceLocation parentID = ResourceLocation.parse((String)parent);
                    if (map.containsKey(parentID)) {
                        upgradedMachines.add(new Triplet((Object)parentID, id, (Object)jsonObject));
                    } else {
                        ICustomMachineryAPI.INSTANCE.logger().error("Upgraded machine '{}' reference parent machine '{}' which doesn't exist, skipping", id, (Object)parentID);
                    }
                    return;
                }
                catch (ResourceLocationException e) {
                    ICustomMachineryAPI.INSTANCE.logger().error("Invalid parent ID '{}' in machine json '{}', skipping...\n{}", (Object)parent, id, (Object)e.getMessage());
                    return;
                }
            }
            DataResult<CustomMachine> result = CustomMachine.CODEC.read(JsonOps.INSTANCE, json);
            if (result.result().isPresent()) {
                CustomMachine machine = (CustomMachine)result.result().get();
                machine.setLocation(location);
                if (id.getPath().startsWith("template/")) {
                    MutableComponent tooltip = Component.empty();
                    if (jsonObject.has("template.tooltip") && jsonObject.get("template.tooltip").isJsonPrimitive() && jsonObject.getAsJsonPrimitive("template.tooltip").isString()) {
                        tooltip = Component.translatable((String)jsonObject.getAsJsonPrimitive("template.tooltip").getAsString());
                    }
                    CustomMachinery.TEMPLATES.put((ResourceLocation)id, (Pair<CustomMachine, Component>)Pair.of((Object)machine, (Object)tooltip));
                } else {
                    CustomMachinery.MACHINES.put((ResourceLocation)id, machine);
                    ICustomMachineryAPI.INSTANCE.logger().info("Successfully parsed machine json: {}", id);
                }
            } else if (result.error().isPresent()) {
                ICustomMachineryAPI.INSTANCE.logger().error("Error while parsing machine json: {}, skipping...\n{}", id, (Object)((DataResult.Error)result.error().get()).message());
            }
        });
        while (!upgradedMachines.isEmpty()) {
            Iterator iterator = upgradedMachines.iterator();
            while (iterator.hasNext()) {
                Triplet triplet = (Triplet)iterator.next();
                CustomMachine parent = CustomMachinery.MACHINES.get(triplet.getA());
                if (parent == null) {
                    upgradedMachines.stream().filter(t -> ((ResourceLocation)t.getB()).equals(triplet.getA())).findFirst().ifPresentOrElse(t -> {
                        if (((ResourceLocation)t.getA()).equals(triplet.getB())) {
                            ICustomMachineryAPI.INSTANCE.logger().error("Circular reference in upgraded machines '{}' and '{}' both referencing each other as parent", triplet.getB(), t.getA());
                            iterator.remove();
                        }
                    }, () -> {
                        ICustomMachineryAPI.INSTANCE.logger().error("Upgraded machine '{}' reference parent machine '{}' which was not loaded, skipping", triplet.getB(), triplet.getA());
                        iterator.remove();
                    });
                    continue;
                }
                ResourceLocation id2 = (ResourceLocation)triplet.getB();
                DataResult<UpgradedCustomMachine> result = UpgradedCustomMachine.makeCodec(parent).read(JsonOps.INSTANCE, (JsonElement)triplet.getC());
                if (result.result().isPresent()) {
                    CustomMachine machine = (CustomMachine)result.result().get();
                    machine.setLocation(this.getMachineLocation(resourceManager, id2));
                    CustomMachinery.MACHINES.put(id2, machine);
                    ICustomMachineryAPI.INSTANCE.logger().info("Successfully parsed upgraded machine json: {}", (Object)id2);
                } else if (result.error().isPresent()) {
                    ICustomMachineryAPI.INSTANCE.logger().error("Error while parsing upgraded machine json: {}, skipping...\n{}", (Object)id2, (Object)((DataResult.Error)result.error().get()).message());
                }
                iterator.remove();
            }
        }
        context = null;
        ICustomMachineryAPI.INSTANCE.logger().info("Finished creating {} custom machines.", (Object)CustomMachinery.MACHINES.keySet().size());
        if (ServerLifecycleHooks.getCurrentServer() != null) {
            MachineList.setNeedRefresh();
        }
        FunctionRequirement.errors.clear();
    }

    /*
     * Exception decompiling
     */
    private MachineLocation getMachineLocation(ResourceManager resourceManager, ResourceLocation id) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK], 1[TRYBLOCK], 12[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

