/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.integration.crafttweaker;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.action.base.IAction;
import com.blamejared.crafttweaker.api.action.base.IRuntimeAction;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.google.common.collect.ImmutableList;
import fr.frinn.custommachinery.CustomMachinery;
import fr.frinn.custommachinery.api.requirement.RequirementIOMode;
import fr.frinn.custommachinery.api.requirement.RequirementType;
import fr.frinn.custommachinery.api.upgrade.Operation;
import fr.frinn.custommachinery.common.integration.crafttweaker.RequirementTypeCTBrackets;
import fr.frinn.custommachinery.common.upgrade.MachineUpgrade;
import fr.frinn.custommachinery.common.upgrade.RecipeModifier;
import fr.frinn.custommachinery.common.upgrade.UpgradeLocation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.custommachinery.CMUpgradeBuilder")
public class CustomMachineUpgradeCTBuilder {
    private final Item item;
    private List<Component> tooltips;
    private final List<ResourceLocation> machines;
    private final List<RecipeModifier> modifiers;
    private final int maxAmount;

    public CustomMachineUpgradeCTBuilder(Item item, int maxAmount) {
        this.item = item;
        this.tooltips = Collections.singletonList(Component.translatable((String)"custommachinery.upgrade.tooltip").withStyle(ChatFormatting.AQUA));
        this.maxAmount = maxAmount;
        this.machines = new ArrayList<ResourceLocation>();
        this.modifiers = new ArrayList<RecipeModifier>();
    }

    @ZenCodeType.Method
    public static CustomMachineUpgradeCTBuilder create(Item item, @ZenCodeType.OptionalInt(value=64) int maxAmount) {
        return new CustomMachineUpgradeCTBuilder(item, maxAmount);
    }

    @ZenCodeType.Method
    public void build() {
        if (this.machines.isEmpty()) {
            throw new IllegalArgumentException("You must specify at least 1 machine for machine upgrade item: " + String.valueOf(BuiltInRegistries.ITEM.getKey((Object)this.item)));
        }
        if (this.modifiers.isEmpty()) {
            throw new IllegalArgumentException("You must specify at least 1 recipe modifier for machine upgrade item: " + String.valueOf(BuiltInRegistries.ITEM.getKey((Object)this.item)));
        }
        MachineUpgrade upgrade = new MachineUpgrade(this.item, this.machines, this.modifiers, Collections.emptyList(), Optional.empty(), this.tooltips, this.maxAmount);
        CraftTweakerAPI.apply((IAction)new AddMachineUpgradeAction(upgrade));
    }

    @ZenCodeType.Method
    public CustomMachineUpgradeCTBuilder machine(String ... string) {
        for (String s : string) {
            ResourceLocation machine;
            try {
                machine = ResourceLocation.parse((String)s);
            }
            catch (ResourceLocationException e) {
                throw new IllegalArgumentException("Invalid Machine ID: " + s + "\n" + e.getMessage());
            }
            this.machines.add(machine);
        }
        return this;
    }

    @ZenCodeType.Method
    public CustomMachineUpgradeCTBuilder tooltip(String ... strings) {
        ImmutableList.Builder tooltips = ImmutableList.builder();
        for (String tooltip : strings) {
            tooltips.add((Object)Component.translatable((String)tooltip));
        }
        this.tooltips = tooltips.build();
        return this;
    }

    @ZenCodeType.Method
    public CustomMachineUpgradeCTBuilder tooltip(Component ... components) {
        this.tooltips = ImmutableList.copyOf((Object[])components);
        return this;
    }

    @ZenCodeType.Method
    public CustomMachineUpgradeCTBuilder modifier(CTRecipeModifierBuilder builder) {
        this.modifiers.add(builder.build());
        return this;
    }

    public static class AddMachineUpgradeAction
    implements IRuntimeAction {
        private final MachineUpgrade upgrade;

        public AddMachineUpgradeAction(MachineUpgrade upgrade) {
            this.upgrade = upgrade;
        }

        public void apply() {
            CustomMachinery.UPGRADES.addUpgrade(UpgradeLocation.fromDefault(ResourceLocation.parse((String)"CT"), ""), this.upgrade);
        }

        public String describe() {
            return "Add a custom machine upgrade for item: " + String.valueOf(BuiltInRegistries.ITEM.getKey((Object)this.upgrade.item()));
        }

        public String systemName() {
            return "custommachinery";
        }
    }

    @ZenRegister
    @ZenCodeType.Name(value="mods.custommachinery.CMRecipeModifierBuilder")
    public static class CTRecipeModifierBuilder {
        private final RequirementType<?> requirement;
        private final RequirementIOMode mode;
        private final Operation operation;
        private final double modifier;
        private String target = "";
        private double chance = 1.0;
        private double max = Double.POSITIVE_INFINITY;
        private double min = Double.NEGATIVE_INFINITY;
        private Component tooltip = null;

        private CTRecipeModifierBuilder(RequirementType<?> type, RequirementIOMode mode, Operation operation, double modifier) {
            this.requirement = type;
            this.mode = mode;
            this.operation = operation;
            this.modifier = modifier;
        }

        @ZenCodeType.Method
        public static CTRecipeModifierBuilder addInput(RequirementTypeCTBrackets.CTRequirementType type, double modifier) {
            return new CTRecipeModifierBuilder(type.getType(), RequirementIOMode.INPUT, Operation.ADDITION, modifier);
        }

        @ZenCodeType.Method
        public static CTRecipeModifierBuilder mulInput(RequirementTypeCTBrackets.CTRequirementType type, double modifier) {
            return new CTRecipeModifierBuilder(type.getType(), RequirementIOMode.INPUT, Operation.MULTIPLICATION, modifier);
        }

        @ZenCodeType.Method
        public static CTRecipeModifierBuilder expInput(RequirementTypeCTBrackets.CTRequirementType type, double modifier) {
            return new CTRecipeModifierBuilder(type.getType(), RequirementIOMode.INPUT, Operation.EXPONENTIAL, modifier);
        }

        @ZenCodeType.Method
        public static CTRecipeModifierBuilder addOutput(RequirementTypeCTBrackets.CTRequirementType type, double modifier) {
            return new CTRecipeModifierBuilder(type.getType(), RequirementIOMode.OUTPUT, Operation.ADDITION, modifier);
        }

        @ZenCodeType.Method
        public static CTRecipeModifierBuilder mulOutput(RequirementTypeCTBrackets.CTRequirementType type, double modifier) {
            return new CTRecipeModifierBuilder(type.getType(), RequirementIOMode.OUTPUT, Operation.MULTIPLICATION, modifier);
        }

        @ZenCodeType.Method
        public static CTRecipeModifierBuilder expOutput(RequirementTypeCTBrackets.CTRequirementType type, double modifier) {
            return new CTRecipeModifierBuilder(type.getType(), RequirementIOMode.OUTPUT, Operation.EXPONENTIAL, modifier);
        }

        @ZenCodeType.Method
        public CTRecipeModifierBuilder target(String target) {
            this.target = target;
            return this;
        }

        @ZenCodeType.Method
        public CTRecipeModifierBuilder chance(double chance) {
            this.chance = chance;
            return this;
        }

        @ZenCodeType.Method
        public CTRecipeModifierBuilder max(double max) {
            this.max = max;
            return this;
        }

        @ZenCodeType.Method
        public CTRecipeModifierBuilder min(double min) {
            this.min = min;
            return this;
        }

        @ZenCodeType.Method
        public CTRecipeModifierBuilder tooltip(String tooltip) {
            this.tooltip = Component.translatable((String)tooltip);
            return this;
        }

        @ZenCodeType.Method
        public CTRecipeModifierBuilder tooltip(Component tooltip) {
            this.tooltip = tooltip;
            return this;
        }

        private RecipeModifier build() {
            return new RecipeModifier(this.requirement, this.mode, this.target, this.operation, this.modifier, this.chance, this.max, this.min, this.tooltip);
        }
    }
}

