/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.init;

import com.mojang.datafixers.util.Pair;
import fr.frinn.custommachinery.common.init.CustomMachineBlock;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.util.Utils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class BoxCreatorItem
extends Item {
    public BoxCreatorItem(Item.Properties properties) {
        super(properties);
    }

    public static BlockPos getSelectedBlock(boolean first, ItemStack stack) {
        Pair selectedBlocks = (Pair)stack.get(Registration.BOX_CREATOR_DATA);
        if (selectedBlocks == null) {
            return BlockPos.ZERO;
        }
        return first ? (BlockPos)selectedBlocks.getFirst() : (BlockPos)selectedBlocks.getSecond();
    }

    public static void setSelectedBlock(boolean first, ItemStack stack, BlockPos pos) {
        stack.update(Registration.BOX_CREATOR_DATA, (Object)Pair.of((Object)BlockPos.ZERO, (Object)BlockPos.ZERO), pair -> first ? Pair.of((Object)pos, (Object)((BlockPos)pair.getSecond())) : Pair.of((Object)((BlockPos)pair.getFirst()), (Object)pos));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltip, flag);
        BlockPos block1 = BoxCreatorItem.getSelectedBlock(true, stack);
        if (block1 != BlockPos.ZERO) {
            tooltip.add((Component)Component.translatable((String)"custommachinery.box_creator.first_block", (Object[])new Object[]{block1.toShortString()}).withStyle(ChatFormatting.BLUE));
        } else {
            tooltip.add((Component)Component.translatable((String)"custommachinery.box_creator.select_first_block").withStyle(ChatFormatting.BLUE));
        }
        BlockPos block2 = BoxCreatorItem.getSelectedBlock(false, stack);
        if (block2 != BlockPos.ZERO) {
            tooltip.add((Component)Component.translatable((String)"custommachinery.box_creator.second_block", (Object[])new Object[]{block2.toShortString()}).withStyle(ChatFormatting.RED));
        } else {
            tooltip.add((Component)Component.translatable((String)"custommachinery.box_creator.select_second_block").withStyle(ChatFormatting.RED));
        }
        if (block1 != BlockPos.ZERO && block2 != BlockPos.ZERO) {
            tooltip.add((Component)Component.translatable((String)"custommachinery.box_creator.select_machine").withStyle(ChatFormatting.GREEN));
        }
        tooltip.add((Component)Component.translatable((String)"custommachinery.box_creator.reset").withStyle(ChatFormatting.GOLD));
    }

    public InteractionResult useOn(UseOnContext context) {
        if (context.getPlayer() == null) {
            return InteractionResult.PASS;
        }
        ItemStack stack = context.getItemInHand();
        BlockPos pos = context.getClickedPos();
        BlockPos block1 = BoxCreatorItem.getSelectedBlock(true, stack);
        BlockPos block2 = BoxCreatorItem.getSelectedBlock(false, stack);
        if (!(context.getLevel().getBlockState(pos).getBlock() instanceof CustomMachineBlock)) {
            BoxCreatorItem.setSelectedBlock(false, stack, pos);
            return InteractionResult.SUCCESS;
        }
        if (block1 != null && block2 != null && !context.getLevel().isClientSide()) {
            AABB aabb = new AABB((double)block1.getX(), (double)block1.getY(), (double)block1.getZ(), (double)block2.getX(), (double)block2.getY(), (double)block2.getZ());
            aabb = aabb.move((double)(-pos.getX()), (double)(-pos.getY()), (double)(-pos.getZ()));
            Direction direction = (Direction)context.getLevel().getBlockState(pos).getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
            aabb = Utils.rotateBox(aabb, direction.getOpposite());
            String boxString = "[" + (int)aabb.minX + ", " + (int)aabb.minY + ", " + (int)aabb.minZ + ", " + (int)aabb.maxX + ", " + (int)aabb.maxY + ", " + (int)aabb.maxZ + "]";
            MutableComponent boxText = Component.literal((String)boxString).withStyle(Style.EMPTY.applyFormat(ChatFormatting.AQUA).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.translatable((String)"custommachinery.box_creator.copy"))).withClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, boxString)));
            MutableComponent message = Component.translatable((String)"custommachinery.box_creator.create_box", (Object[])new Object[]{boxText});
            context.getPlayer().sendSystemMessage((Component)message);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean canAttackBlock(BlockState state, Level level, BlockPos pos, Player player) {
        return false;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player.isCrouching() && stack.getItem() == this) {
            stack.remove(Registration.BOX_CREATOR_DATA);
            return InteractionResultHolder.success((Object)stack);
        }
        return super.use(level, player, hand);
    }

    public boolean isFoil(ItemStack stack) {
        return true;
    }
}

