/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.common.component;

import com.google.common.collect.AbstractIterator;
import fr.frinn.custommachinery.api.component.ComponentIOMode;
import fr.frinn.custommachinery.api.component.IMachineComponentManager;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.requirement.BlockRequirement;
import fr.frinn.custommachinery.common.util.BlockIngredient;
import fr.frinn.custommachinery.common.util.PartialBlockState;
import fr.frinn.custommachinery.common.util.Utils;
import fr.frinn.custommachinery.impl.component.AbstractMachineComponent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class BlockMachineComponent
extends AbstractMachineComponent {
    public BlockMachineComponent(IMachineComponentManager manager) {
        super(manager, ComponentIOMode.BOTH);
    }

    public MachineComponentType<BlockMachineComponent> getType() {
        return Registration.BLOCK_MACHINE_COMPONENT.get();
    }

    public long getBlockAmount(AABB box, List<BlockIngredient> filter, boolean whitelist) {
        box = Utils.rotateBox(box, (Direction)this.getManager().getTile().getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING));
        box = box.move(this.getManager().getTile().getBlockPos());
        return this.getBlockPos(BlockRequirement.Order.INCREASING, box).map(pos -> new BlockInWorld((LevelReader)this.getManager().getLevel(), pos, false)).filter(block -> filter.stream().flatMap(ingredient -> ingredient.getAll().stream()).anyMatch(state -> state.test((BlockInWorld)block)) == whitelist).count();
    }

    public boolean placeBlock(AABB box, BlockRequirement.Order order, PartialBlockState block, int amount) {
        box = Utils.rotateBox(box, (Direction)this.getManager().getTile().getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING));
        box = box.move(this.getManager().getTile().getBlockPos());
        if (this.getBlockPos(order, box).map(arg_0 -> ((Level)this.getManager().getLevel()).getBlockState(arg_0)).filter(state -> state.getBlock() == Blocks.AIR).count() < (long)amount) {
            return false;
        }
        AtomicInteger toPlace = new AtomicInteger(amount);
        this.getBlockPos(order, box).forEach(pos -> {
            if (toPlace.get() > 0 && this.getManager().getLevel().getBlockState(pos).getBlock() == Blocks.AIR) {
                this.setBlock(this.getManager().getLevel(), (BlockPos)pos, block);
                toPlace.addAndGet(-1);
            }
        });
        return true;
    }

    public boolean replaceBlock(AABB box, BlockRequirement.Order order, PartialBlockState block, int amount, boolean drop, List<BlockIngredient> filter, boolean whitelist) {
        if (this.getBlockAmount(box, filter, whitelist) < (long)amount) {
            return false;
        }
        box = Utils.rotateBox(box, (Direction)this.getManager().getTile().getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING));
        box = box.move(this.getManager().getTile().getBlockPos());
        AtomicInteger toPlace = new AtomicInteger(amount);
        this.getBlockPos(order, box).forEach(pos -> {
            if (toPlace.get() > 0) {
                BlockInWorld cached = new BlockInWorld((LevelReader)this.getManager().getLevel(), pos, false);
                if (filter.stream().flatMap(ingredient -> ingredient.getAll().stream()).anyMatch(state -> state.test(cached)) == whitelist) {
                    if (!cached.getState().isAir()) {
                        this.getManager().getLevel().destroyBlock(pos, drop);
                    }
                    this.setBlock(this.getManager().getLevel(), (BlockPos)pos, block);
                    toPlace.addAndGet(-1);
                }
            }
        });
        return true;
    }

    public boolean breakBlock(AABB box, BlockRequirement.Order order, List<BlockIngredient> filter, boolean whitelist, int amount, boolean drop) {
        if (this.getBlockAmount(box, filter, whitelist) < (long)amount) {
            return false;
        }
        box = Utils.rotateBox(box, (Direction)this.getManager().getTile().getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING));
        box = box.move(this.getManager().getTile().getBlockPos());
        AtomicInteger toPlace = new AtomicInteger(amount);
        this.getBlockPos(order, box).forEach(pos -> {
            if (toPlace.get() > 0) {
                BlockInWorld cached = new BlockInWorld((LevelReader)this.getManager().getLevel(), pos, false);
                if (filter.stream().flatMap(ingredient -> ingredient.getAll().stream()).anyMatch(state -> state.test(cached)) == whitelist) {
                    if (!cached.getState().isAir()) {
                        this.getManager().getLevel().destroyBlock(pos, drop);
                    }
                    toPlace.addAndGet(-1);
                }
            }
        });
        return true;
    }

    private void setBlock(Level world, BlockPos pos, PartialBlockState state) {
        world.setBlockAndUpdate(pos, state.getBlockState());
        BlockEntity tile = world.getBlockEntity(pos);
        if (tile != null && state.getNbt() != null && !state.getNbt().isEmpty()) {
            CompoundTag nbt = state.getNbt().copy();
            nbt.putInt("x", pos.getX());
            nbt.putInt("y", pos.getY());
            nbt.putInt("z", pos.getZ());
            tile.loadWithComponents(nbt, (HolderLookup.Provider)world.registryAccess());
        }
    }

    private Stream<BlockPos> getBlockPos(BlockRequirement.Order order, AABB aabb) {
        return switch (order) {
            default -> throw new MatchException(null, null);
            case BlockRequirement.Order.INCREASING -> StreamSupport.stream(this.betweenClosed(true, Mth.floor((double)aabb.minX), Mth.floor((double)aabb.minY), Mth.floor((double)aabb.minZ), Mth.floor((double)aabb.maxX), Mth.floor((double)aabb.maxY), Mth.floor((double)aabb.maxZ)).spliterator(), false);
            case BlockRequirement.Order.DECREASING -> StreamSupport.stream(this.betweenClosed(false, Mth.floor((double)aabb.minX), Mth.floor((double)aabb.minY), Mth.floor((double)aabb.minZ), Mth.floor((double)aabb.maxX), Mth.floor((double)aabb.maxY), Mth.floor((double)aabb.maxZ)).spliterator(), false);
            case BlockRequirement.Order.RANDOM -> StreamSupport.stream(this.random(Mth.floor((double)aabb.minX), Mth.floor((double)aabb.minY), Mth.floor((double)aabb.minZ), Mth.floor((double)aabb.maxX), Mth.floor((double)aabb.maxY), Mth.floor((double)aabb.maxZ)).spliterator(), false);
        };
    }

    private Iterable<BlockPos> betweenClosed(final boolean increasing, final int minX, final int minY, final int minZ, int maxX, int maxY, int maxZ) {
        final int xSize = maxX - minX + 1;
        int ySize = maxY - minY + 1;
        final int zSize = maxZ - minZ + 1;
        final int blockAmount = xSize * ySize * zSize;
        return () -> new AbstractIterator<BlockPos>(this){
            private final BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
            private int index = increasing ? blockAmount - 1 : 0;

            protected BlockPos computeNext() {
                if (this.index < 0 || this.index >= blockAmount) {
                    return (BlockPos)this.endOfData();
                }
                int zPos = this.index % zSize;
                int j1 = this.index / zSize;
                int xPos = j1 % xSize;
                int yPos = j1 / xSize;
                this.index += increasing ? -1 : 1;
                return this.cursor.set(minX + xPos, minY + yPos, minZ + zPos);
            }
        };
    }

    private Iterable<BlockPos> random(int minX, int minY, int minZ, final int maxX, final int maxY, final int maxZ) {
        final int xSize = maxX - minX + 1;
        int ySize = maxY - minY + 1;
        final int zSize = maxZ - minZ + 1;
        final int blockAmount = xSize * ySize * zSize;
        final List indexes = IntStream.rangeClosed(0, blockAmount - 1).boxed().collect(Collectors.toCollection(ArrayList::new));
        Collections.shuffle(indexes);
        return () -> new AbstractIterator<BlockPos>(this){
            private final BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
            private int index;

            protected BlockPos computeNext() {
                if (this.index == blockAmount) {
                    return (BlockPos)this.endOfData();
                }
                int blockIndex = (Integer)indexes.get(this.index);
                int zPos = blockIndex % zSize;
                int j1 = blockIndex / zSize;
                int xPos = j1 % xSize;
                int yPos = j1 / xSize;
                ++this.index;
                return this.cursor.set(maxX - xPos, maxY - yPos, maxZ - zPos);
            }
        };
    }
}

