/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.screen.creation.appearance.builder;

import fr.frinn.custommachinery.api.machine.MachineAppearanceProperty;
import fr.frinn.custommachinery.client.screen.BaseScreen;
import fr.frinn.custommachinery.client.screen.creation.appearance.IAppearancePropertyBuilder;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public abstract class NumberAppearancePropertyBuilder<T extends Number>
implements IAppearancePropertyBuilder<T> {
    private final Component title;
    private final MachineAppearanceProperty<T> type;
    private final T min;
    private final T max;
    @Nullable
    private final Component tooltip;

    public NumberAppearancePropertyBuilder(Component title, MachineAppearanceProperty<T> type, T min, T max, @Nullable Component tooltip) {
        this.title = title;
        this.type = type;
        this.min = min;
        this.max = max;
        this.tooltip = tooltip;
    }

    public abstract T fromDouble(double var1);

    @Override
    public Component title() {
        return this.title;
    }

    @Override
    public MachineAppearanceProperty<T> type() {
        return this.type;
    }

    @Override
    public AbstractWidget makeWidget(BaseScreen parent, int x, int y, int width, int height, Supplier<T> supplier, final Consumer<T> consumer) {
        double value = Mth.map((double)((Number)supplier.get()).doubleValue(), (double)((Number)this.min).doubleValue(), (double)((Number)this.max).doubleValue(), (double)0.0, (double)1.0);
        AbstractSliderButton button = new AbstractSliderButton(x, y, width, height, (Component)Component.empty().append(this.title).append(": " + (int)((Number)supplier.get()).doubleValue()), value){

            private double value() {
                return Mth.map((double)this.value, (double)0.0, (double)1.0, (double)((Number)NumberAppearancePropertyBuilder.this.min).doubleValue(), (double)((Number)NumberAppearancePropertyBuilder.this.max).doubleValue());
            }

            private void setValue(double value) {
                this.value = Mth.clamp((double)Mth.map((double)value, (double)((Number)NumberAppearancePropertyBuilder.this.min).doubleValue(), (double)((Number)NumberAppearancePropertyBuilder.this.max).doubleValue(), (double)0.0, (double)1.0), (double)0.0, (double)1.0);
                this.applyValue();
                this.updateMessage();
            }

            protected void updateMessage() {
                this.setMessage((Component)Component.empty().append(NumberAppearancePropertyBuilder.this.title).append(": " + (int)this.value()));
            }

            protected void applyValue() {
                consumer.accept(NumberAppearancePropertyBuilder.this.fromDouble(this.value()));
            }

            public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
                double value = this.value();
                boolean pressed = super.keyPressed(keyCode, scanCode, modifiers);
                double modifier = Screen.hasShiftDown() ? ((Number)NumberAppearancePropertyBuilder.this.max).doubleValue() / 10.0 : (Screen.hasControlDown() ? ((Number)NumberAppearancePropertyBuilder.this.max).doubleValue() / 20.0 : 1.0);
                switch (keyCode) {
                    case 262: {
                        this.setValue(value + modifier);
                        break;
                    }
                    case 263: {
                        this.setValue(value - modifier);
                    }
                }
                return pressed;
            }
        };
        if (this.tooltip != null) {
            button.setTooltip(Tooltip.create((Component)this.tooltip));
        }
        return button;
    }

    public static class FloatAppearancePropertyBuilder
    extends NumberAppearancePropertyBuilder<Float> {
        public FloatAppearancePropertyBuilder(Component title, MachineAppearanceProperty<Float> type, Float min, Float max, @Nullable Component tooltip) {
            super(title, type, min, max, tooltip);
        }

        @Override
        public Float fromDouble(double value) {
            return Float.valueOf((float)value);
        }
    }

    public static class IntegerAppearancePropertyBuilder
    extends NumberAppearancePropertyBuilder<Integer> {
        public IntegerAppearancePropertyBuilder(Component title, MachineAppearanceProperty<Integer> type, Integer min, Integer max, @Nullable Component tooltip) {
            super(title, type, min, max, tooltip);
        }

        @Override
        public Integer fromDouble(double value) {
            return (int)value;
        }
    }
}

