/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.integration.jei;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import fr.frinn.custommachinery.api.crafting.IMachineRecipe;
import fr.frinn.custommachinery.api.guielement.IGuiElement;
import fr.frinn.custommachinery.api.integration.jei.DisplayInfoTemplate;
import fr.frinn.custommachinery.api.integration.jei.IDisplayInfo;
import fr.frinn.custommachinery.api.integration.jei.IJEIElementRenderer;
import fr.frinn.custommachinery.api.integration.jei.IJEIIngredientWrapper;
import fr.frinn.custommachinery.api.requirement.RecipeRequirement;
import fr.frinn.custommachinery.client.integration.jei.RecipeHelper;
import fr.frinn.custommachinery.client.integration.jei.RequirementDisplayInfo;
import fr.frinn.custommachinery.common.crafting.machine.CustomMachineRecipe;
import fr.frinn.custommachinery.common.init.CustomMachineItem;
import fr.frinn.custommachinery.common.init.Registration;
import fr.frinn.custommachinery.common.machine.CustomMachine;
import fr.frinn.custommachinery.common.util.Comparators;
import fr.frinn.custommachinery.impl.integration.jei.GuiElementJEIRendererRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.gui.inputs.IJeiInputHandler;
import mezz.jei.api.gui.inputs.IJeiUserInput;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.gui.widgets.IRecipeWidget;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenPosition;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.RecipeHolder;

public abstract class AbstractRecipeCategory<T extends IMachineRecipe>
implements IRecipeCategory<T> {
    protected static final int ICON_SIZE = 10;
    protected CustomMachine machine;
    protected final RecipeType<T> recipeType;
    protected final IGuiHelper guiHelper;
    protected final RecipeHelper recipeHelper;
    protected final LoadingCache<RecipeRequirement<?, ?>, RequirementDisplayInfo> infoCache;
    protected LoadingCache<T, List<IJEIIngredientWrapper<?>>> wrapperCache;
    protected int offsetX;
    protected int offsetY;
    protected int width;
    protected int height;
    protected boolean hasInfoRow;
    protected int rowY;
    protected int maxIconPerRow;

    public AbstractRecipeCategory(CustomMachine machine, RecipeType<T> type, IJeiHelpers helpers) {
        this.machine = machine;
        this.recipeType = type;
        this.guiHelper = helpers.getGuiHelper();
        this.recipeHelper = new RecipeHelper(machine, helpers);
        this.infoCache = CacheBuilder.newBuilder().build(new CacheLoader<RecipeRequirement<?, ?>, RequirementDisplayInfo>(this){

            public RequirementDisplayInfo load(RecipeRequirement<?, ?> requirement) {
                RequirementDisplayInfo info = new RequirementDisplayInfo();
                requirement.getDisplayInfo(info);
                DisplayInfoTemplate template = requirement.info;
                if (template != null) {
                    if (!template.getTooltips().isEmpty()) {
                        info.getTooltips().clear();
                    }
                    template.build(info);
                }
                return info;
            }
        });
        this.wrapperCache = CacheBuilder.newBuilder().build(new CacheLoader<T, List<IJEIIngredientWrapper<?>>>(this){

            public List<IJEIIngredientWrapper<?>> load(T recipe) {
                ImmutableList.Builder wrappers = ImmutableList.builder();
                recipe.getDisplayInfoRequirements().forEach(requirement -> wrappers.addAll(requirement.getJeiIngredientWrappers((IMachineRecipe)recipe)));
                return wrappers.build();
            }
        });
        this.setupRecipeDimensions();
    }

    private void setupRecipeDimensions() {
        if (Minecraft.getInstance().level == null) {
            return;
        }
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int maxX = 0;
        int maxY = 0;
        List<IGuiElement> elements = this.machine.getJeiElements().isEmpty() ? this.machine.getGuiElements() : this.machine.getJeiElements();
        for (IGuiElement element : elements) {
            if (!GuiElementJEIRendererRegistry.hasJEIRenderer(element.getType()) || !element.showInJei()) continue;
            minX = Math.min(minX, element.getX());
            minY = Math.min(minY, element.getY());
            maxX = Math.max(maxX, element.getX() + element.getWidth());
            maxY = Math.max(maxY, element.getY() + element.getHeight());
        }
        this.rowY = Math.max(maxY - minY, 20);
        this.offsetX = Math.max(minX, 0);
        this.offsetY = Math.max(minY, 0);
        this.width = Math.max(maxX - minX, 20);
        this.maxIconPerRow = this.width / 12;
        long maxDisplayRequirement = Minecraft.getInstance().level.getRecipeManager().getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)Registration.CUSTOM_MACHINE_RECIPE.get()).stream().map(RecipeHolder::value).filter(recipe -> recipe.getMachineId().equals((Object)this.machine.getId()) && recipe.showInJei()).mapToLong(recipe -> recipe.getDisplayInfoRequirements().stream().map(this.infoCache).filter(RequirementDisplayInfo::shouldRender).count()).max().orElse(0L);
        this.hasInfoRow = maxDisplayRequirement != 0L;
        int rows = this.hasInfoRow ? Math.toIntExact(maxDisplayRequirement) / this.maxIconPerRow + 1 : 0;
        this.height = this.rowY + 12 * rows;
    }

    public void updateMachine(CustomMachine machine) {
        this.machine = machine;
        this.setupRecipeDimensions();
    }

    public RecipeType<T> getRecipeType() {
        return this.recipeType;
    }

    public Component getTitle() {
        return this.machine.getName();
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public IDrawable getIcon() {
        return this.guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)CustomMachineItem.makeMachineItem(this.machine.getId()));
    }

    public void setRecipe(IRecipeLayoutBuilder builder, T recipe, IFocusGroup focuses) {
        CustomMachineRecipe machineRecipe;
        List<IGuiElement> elements;
        builder.moveRecipeTransferButton(this.width - 11, this.height - 11);
        ArrayList wrappers = new ArrayList((Collection)this.wrapperCache.getUnchecked(recipe));
        List<IGuiElement> list = elements = this.machine.getJeiElements().isEmpty() ? this.machine.getGuiElements() : this.machine.getJeiElements();
        if (recipe instanceof CustomMachineRecipe && !(machineRecipe = (CustomMachineRecipe)recipe).getGuiElements().isEmpty()) {
            elements = machineRecipe.getCustomGuiElements(elements);
        }
        elements.forEach(element -> {
            Iterator iterator = wrappers.iterator();
            while (iterator.hasNext()) {
                IJEIIngredientWrapper wrapper = (IJEIIngredientWrapper)iterator.next();
                if (!wrapper.setupRecipe(builder, this.offsetX, this.offsetY, (IGuiElement)element, this.recipeHelper)) continue;
                iterator.remove();
                break;
            }
        });
    }

    public void draw(T recipe, IRecipeSlotsView slotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        CustomMachineRecipe machineRecipe;
        List<IGuiElement> elements;
        this.guiHelper.createBlankDrawable(this.width, this.height).draw(graphics);
        List<IGuiElement> list = elements = this.machine.getJeiElements().isEmpty() ? this.machine.getGuiElements() : this.machine.getJeiElements();
        if (recipe instanceof CustomMachineRecipe && !(machineRecipe = (CustomMachineRecipe)recipe).getGuiElements().isEmpty()) {
            elements = machineRecipe.getCustomGuiElements(elements);
        }
        elements.stream().filter(element -> GuiElementJEIRendererRegistry.hasJEIRenderer(element.getType()) && element.showInJei()).sorted(Comparators.GUI_ELEMENTS_COMPARATOR.reversed()).forEach(element -> {
            IJEIElementRenderer<IGuiElement> renderer = GuiElementJEIRendererRegistry.getJEIRenderer(element.getType());
            graphics.pose().pushPose();
            graphics.pose().translate((float)(-this.offsetX), (float)(-this.offsetY), 0.0f);
            renderer.renderElementInJEI(graphics, (IGuiElement)element, (IMachineRecipe)recipe, (int)mouseX, (int)mouseY);
            graphics.pose().popPose();
        });
        if (this.hasInfoRow) {
            graphics.fill(-3, this.rowY, this.width + 3, this.rowY + 1, 0x30000000);
        }
    }

    public void getTooltip(ITooltipBuilder builder, T recipe, IRecipeSlotsView view, double mouseX, double mouseY) {
        CustomMachineRecipe machineRecipe;
        List<IGuiElement> elements;
        List<IGuiElement> list = elements = this.machine.getJeiElements().isEmpty() ? this.machine.getGuiElements() : this.machine.getJeiElements();
        if (recipe instanceof CustomMachineRecipe && !(machineRecipe = (CustomMachineRecipe)recipe).getGuiElements().isEmpty()) {
            elements = machineRecipe.getCustomGuiElements(elements);
        }
        for (IGuiElement element : elements) {
            int y;
            int x;
            IJEIElementRenderer<IGuiElement> renderer;
            if (!element.showInJei() || !GuiElementJEIRendererRegistry.hasJEIRenderer(element.getType()) || !(renderer = GuiElementJEIRendererRegistry.getJEIRenderer(element.getType())).isHoveredInJei(element, x = element.getX() - this.offsetX, y = element.getY() - this.offsetY, (int)mouseX, (int)mouseY)) continue;
            builder.addAll(renderer.getJEITooltips(element, (IMachineRecipe)recipe));
            return;
        }
    }

    public void createRecipeExtras(IRecipeExtrasBuilder builder, T recipe, IFocusGroup focuses) {
        if (!this.hasInfoRow) {
            return;
        }
        AtomicInteger index = new AtomicInteger();
        AtomicInteger row = new AtomicInteger(0);
        recipe.getDisplayInfoRequirements().stream().map(this.infoCache).filter(RequirementDisplayInfo::shouldRender).forEach(info -> {
            int x = index.get() * 12 - 2;
            int y = this.rowY + 2 + 12 * row.get();
            if (index.incrementAndGet() >= this.maxIconPerRow) {
                index.set(0);
                row.incrementAndGet();
            }
            DisplayInfoWidget widget = new DisplayInfoWidget(this, x, y, info, recipe);
            builder.addWidget((IRecipeWidget)widget);
            builder.addInputHandler((IJeiInputHandler)widget);
        });
    }

    public static class DisplayInfoWidget
    implements IRecipeWidget,
    IJeiInputHandler {
        private final ScreenPosition pos;
        private final ScreenRectangle area;
        private final RequirementDisplayInfo info;
        private final T recipe;
        final /* synthetic */ AbstractRecipeCategory this$0;

        public DisplayInfoWidget(int x, int y, RequirementDisplayInfo info, T recipe) {
            this.this$0 = this$0;
            this.pos = new ScreenPosition(x, y);
            this.area = new ScreenRectangle(x, y, 10, 10);
            this.info = info;
            this.recipe = recipe;
        }

        public ScreenPosition getPosition() {
            return this.pos;
        }

        public void drawWidget(GuiGraphics graphics, double mouseX, double mouseY) {
            this.info.renderIcon(graphics, 10);
        }

        public void getTooltip(ITooltipBuilder builder, double mouseX, double mouseY) {
            if (mouseX > 10.0 || mouseY > 10.0 || mouseX < -1.0 || mouseY < 0.0) {
                return;
            }
            this.info.getTooltips().stream().filter(pair -> ((IDisplayInfo.TooltipPredicate)pair.getSecond()).shouldDisplay((Player)Minecraft.getInstance().player, Minecraft.getInstance().options.advancedItemTooltips)).map(Pair::getFirst).forEach(arg_0 -> ((ITooltipBuilder)builder).add(arg_0));
        }

        public ScreenRectangle getArea() {
            return this.area;
        }

        public boolean handleInput(double mouseX, double mouseY, IJeiUserInput input) {
            if (Minecraft.getInstance().screen == null) {
                return false;
            }
            if (input.isSimulate()) {
                return true;
            }
            return input.getKey().getValue() == 0 && this.info.handleClick(this.this$0.machine, (IMachineRecipe)this.recipe, input.getKey().getValue());
        }
    }
}

