/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.client.element;

import fr.frinn.custommachinery.api.crafting.IProcessor;
import fr.frinn.custommachinery.api.guielement.IMachineScreen;
import fr.frinn.custommachinery.client.render.ProgressArrowRenderer;
import fr.frinn.custommachinery.common.crafting.machine.MachineProcessor;
import fr.frinn.custommachinery.common.crafting.machine.MachineProcessorCore;
import fr.frinn.custommachinery.common.guielement.ProgressBarGuiElement;
import fr.frinn.custommachinery.impl.guielement.AbstractGuiElementWidget;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;

public class ProgressGuiElementWidget
extends AbstractGuiElementWidget<ProgressBarGuiElement> {
    public ProgressGuiElementWidget(ProgressBarGuiElement element, IMachineScreen screen) {
        super(element, screen, (Component)Component.literal((String)"Progress Bar"));
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        ProgressArrowRenderer.renderProgressArrow(graphics, (ProgressBarGuiElement)this.getElement(), this.getX(), this.getY(), this.getRecipeProgressPercent());
    }

    public double getRecipeProgressPercent() {
        MachineProcessor machineProcessor;
        IProcessor iProcessor = this.getScreen().getTile().getProcessor();
        if (iProcessor instanceof MachineProcessor && (machineProcessor = (MachineProcessor)iProcessor).getCores().size() > ((ProgressBarGuiElement)this.getElement()).getCore()) {
            MachineProcessorCore core = machineProcessor.getCores().get(((ProgressBarGuiElement)this.getElement()).getCore());
            if (core.getRecipeTotalTime() == 0.0) {
                return 0.0;
            }
            return core.getRecipeProgressTime() / core.getRecipeTotalTime();
        }
        if (this.getScreen().getTile().getMachine().isDummy()) {
            return (double)(System.currentTimeMillis() % 2000L) / 2000.0;
        }
        return 0.0;
    }

    protected boolean clicked(double mouseX, double mouseY) {
        return false;
    }
}

