/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.world.height;

import mekanism.api.text.IHasTranslationKey;
import mekanism.api.text.ILangEntry;
import mekanism.common.MekanismLang;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import org.jetbrains.annotations.NotNull;

public enum AnchorType implements IHasTranslationKey.IHasEnumNameTranslationKey
{
    ABSOLUTE(MekanismLang.ANCHOR_TYPE_ABSOLUTE, (context, value) -> value),
    ABOVE_BOTTOM(MekanismLang.ANCHOR_TYPE_ABOVE_BOTTOM, (context, value) -> context.getMinGenY() + value),
    BELOW_TOP(MekanismLang.ANCHOR_TYPE_BELOW_TOP, (context, value) -> context.getGenDepth() - 1 + context.getMinGenY() - value);

    private final ILangEntry langEntry;
    private final YResolver yResolver;

    private AnchorType(ILangEntry langEntry, YResolver yResolver) {
        this.langEntry = langEntry;
        this.yResolver = yResolver;
    }

    public int resolveY(WorldGenerationContext context, int value) {
        return this.yResolver.resolve(context, value);
    }

    @Override
    @NotNull
    public String getTranslationKey() {
        return this.langEntry.getTranslationKey();
    }

    @FunctionalInterface
    private static interface YResolver {
        public int resolve(WorldGenerationContext var1, int var2);
    }
}

