/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_client.container;

import java.util.List;
import mekanism.common.Mekanism;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.network.to_client.container.property.PropertyData;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record PacketUpdateContainer(short windowId, List<PropertyData> data) implements IMekanismPacket
{
    public static final CustomPacketPayload.Type<PacketUpdateContainer> TYPE = new CustomPacketPayload.Type(Mekanism.rl("update_container"));
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketUpdateContainer> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.SHORT, PacketUpdateContainer::windowId, (StreamCodec)PropertyData.GENERIC_STREAM_CODEC.apply(ByteBufCodecs.list()), PacketUpdateContainer::data, PacketUpdateContainer::new);

    @NotNull
    public CustomPacketPayload.Type<PacketUpdateContainer> type() {
        return TYPE;
    }

    @Override
    public void handle(IPayloadContext context) {
        AbstractContainerMenu abstractContainerMenu = context.player().containerMenu;
        if (abstractContainerMenu instanceof MekanismContainer) {
            MekanismContainer container = (MekanismContainer)abstractContainerMenu;
            if (container.containerId == this.windowId) {
                for (PropertyData datum : this.data) {
                    datum.handleWindowProperty(container);
                }
            }
        }
    }
}

