/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.radiation;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.common.lib.radiation.Meltdown;
import mekanism.common.registries.MekanismAttachmentTypes;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.ListTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
@EventBusSubscriber(modid="mekanism")
public class MeltdownLevelData
implements INBTSerializable<ListTag> {
    private final List<Meltdown> meltdowns = new ArrayList<Meltdown>();

    public void createMeltdown(BlockPos minPos, BlockPos maxPos, double magnitude, double chance, float radius, UUID multiblockID) {
        this.meltdowns.add(new Meltdown(minPos, maxPos, magnitude, chance, radius, multiblockID));
    }

    @SubscribeEvent
    public static void tickWorld(LevelTickEvent.Post event) {
        Level level = event.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            MeltdownLevelData existingData = (MeltdownLevelData)level.getExistingDataOrNull(MekanismAttachmentTypes.MELTDOWN_DATA);
            if (existingData != null) {
                existingData.tick(serverLevel);
            }
        }
    }

    public void tick(ServerLevel world) {
        if (this.meltdowns.isEmpty()) {
            return;
        }
        Iterator<Meltdown> iterator = this.meltdowns.iterator();
        while (iterator.hasNext()) {
            Meltdown meltdown = iterator.next();
            if (!meltdown.update(world)) continue;
            iterator.remove();
        }
    }

    public void deserializeNBT(HolderLookup.Provider provider, ListTag meltdownList) {
        for (int i = 0; i < meltdownList.size(); ++i) {
            Meltdown meltdown = Meltdown.load(meltdownList.getCompound(i));
            if (meltdown == null) continue;
            this.meltdowns.add(meltdown);
        }
    }

    @Nullable
    public ListTag serializeNBT(HolderLookup.Provider provider) {
        if (this.meltdowns.isEmpty()) {
            return null;
        }
        ListTag list = new ListTag(this.meltdowns.size());
        for (Meltdown meltdown : this.meltdowns) {
            list.add((Object)meltdown.write());
        }
        return list;
    }
}

