/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.computer.computercraft;

import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.MethodResult;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IDynamicPeripheral;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.lang.ref.WeakReference;
import mekanism.common.integration.computer.IComputerTile;
import mekanism.common.integration.computer.computercraft.CCMethodCaller;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public class MekanismPeripheral<TILE extends BlockEntity>
extends CCMethodCaller
implements IDynamicPeripheral {
    private final String name;
    private final WeakReference<TILE> tile;

    public static <TILE extends BlockEntity> MekanismPeripheral<TILE> create(TILE tile) {
        MekanismPeripheral<TILE> mekanismPeripheral = new MekanismPeripheral<TILE>(tile);
        ((IComputerTile)tile).getComputerMethods(mekanismPeripheral);
        return mekanismPeripheral;
    }

    private MekanismPeripheral(TILE tile) {
        this.tile = new WeakReference<TILE>(tile);
        this.name = ((IComputerTile)tile).getComputerName();
    }

    public MethodResult callMethod(IComputerAccess computer, ILuaContext context, int method, IArguments arguments) throws LuaException {
        return this.callMethod(context, method, arguments);
    }

    public String getType() {
        return this.name;
    }

    @Nullable
    public Object getTarget() {
        return this.tile.get();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable IPeripheral other) {
        Object target = this.getTarget();
        if (!(other instanceof MekanismPeripheral)) return false;
        MekanismPeripheral otherP = (MekanismPeripheral)other;
        if (target == null) return false;
        if (target != other.getTarget()) return false;
        if (!this.methods.equals((Object)otherP.methods)) return false;
        return true;
    }

    public boolean equals(Object obj) {
        MekanismPeripheral other;
        return obj instanceof MekanismPeripheral && this.equals((IPeripheral)(other = (MekanismPeripheral)obj));
    }

    public int hashCode() {
        int result = this.name.hashCode();
        BlockEntity tileRef = (BlockEntity)this.tile.get();
        result = 31 * result + (tileRef == null ? 0 : tileRef.hashCode());
        result = 0x1F & result + this.methods.hashCode();
        return result;
    }
}

