/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.network.transmitter;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.BasicChemicalTank;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.chemical.IChemicalTank;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.chemical.IChemicalTracker;
import mekanism.common.content.network.ChemicalNetwork;
import mekanism.common.content.network.transmitter.BufferedTransmitter;
import mekanism.common.content.network.transmitter.IUpgradeableTransmitter;
import mekanism.common.content.network.transmitter.Transmitter;
import mekanism.common.lib.transmitter.CompatibleTransmitterValidator;
import mekanism.common.lib.transmitter.ConnectionType;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.lib.transmitter.acceptor.AbstractAcceptorCache;
import mekanism.common.lib.transmitter.acceptor.AcceptorCache;
import mekanism.common.tier.TubeTier;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import mekanism.common.upgrade.transmitter.PressurizedTubeUpgradeData;
import mekanism.common.upgrade.transmitter.TransmitterUpgradeData;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PressurizedTube
extends BufferedTransmitter<IChemicalHandler, ChemicalNetwork, ChemicalStack, PressurizedTube>
implements IChemicalTracker,
IUpgradeableTransmitter<PressurizedTubeUpgradeData> {
    public final TubeTier tier;
    public final IChemicalTank chemicalTank;
    private final List<IChemicalTank> chemicalTanks;
    @NotNull
    public ChemicalStack saveShare = ChemicalStack.EMPTY;

    public PressurizedTube(Holder<Block> blockProvider, TileEntityTransmitter tile) {
        super(tile, TransmissionType.CHEMICAL);
        this.tier = Attribute.getTier(blockProvider, TubeTier.class);
        this.chemicalTank = BasicChemicalTank.createAllValid(this.getCapacity(), this);
        this.chemicalTanks = Collections.singletonList(this.chemicalTank);
    }

    @Override
    protected AbstractAcceptorCache<IChemicalHandler, ?> createAcceptorCache() {
        return new AcceptorCache<IChemicalHandler>(this.getTransmitterTile(), Capabilities.CHEMICAL.block());
    }

    public AcceptorCache<IChemicalHandler> getAcceptorCache() {
        return (AcceptorCache)super.getAcceptorCache();
    }

    @Override
    public TubeTier getTier() {
        return this.tier;
    }

    @Override
    public void pullFromAcceptors() {
        if (!this.hasPullSide || this.getAvailablePull() <= 0L) {
            return;
        }
        AbstractAcceptorCache acceptorCache = this.getAcceptorCache();
        for (Direction side : EnumUtils.DIRECTIONS) {
            IChemicalHandler connectedAcceptor;
            if (!this.isConnectionType(side, ConnectionType.PULL) || (connectedAcceptor = (IChemicalHandler)acceptorCache.getConnectedAcceptor(side)) == null) continue;
            ChemicalStack bufferWithFallback = this.getBufferWithFallback();
            this.pullFromAcceptor(connectedAcceptor, bufferWithFallback, bufferWithFallback.isEmpty());
        }
    }

    private boolean pullFromAcceptor(IChemicalHandler connectedAcceptor, ChemicalStack bufferWithFallback, boolean bufferIsEmpty) {
        if (connectedAcceptor == null) {
            return false;
        }
        long availablePull = this.getAvailablePull();
        ChemicalStack received = bufferIsEmpty ? connectedAcceptor.extractChemical(availablePull, Action.SIMULATE) : connectedAcceptor.extractChemical(bufferWithFallback.copyWithAmount(availablePull), Action.SIMULATE);
        if (!received.isEmpty() && this.takeChemical(received, Action.SIMULATE).isEmpty()) {
            this.takeChemical(connectedAcceptor.extractChemical(received, Action.EXECUTE), Action.EXECUTE);
            return true;
        }
        return false;
    }

    private long getAvailablePull() {
        if (this.hasTransmitterNetwork()) {
            return Math.min(this.tier.getTubePullAmount(), ((ChemicalNetwork)this.getTransmitterNetwork()).chemicalTank.getNeeded());
        }
        return Math.min(this.tier.getTubePullAmount(), this.chemicalTank.getNeeded());
    }

    @Override
    @Nullable
    public PressurizedTubeUpgradeData getUpgradeData() {
        return new PressurizedTubeUpgradeData(this.redstoneReactive, this.getConnectionTypesRaw(), this.getShare());
    }

    @Override
    public boolean dataTypeMatches(@NotNull TransmitterUpgradeData data) {
        return data instanceof PressurizedTubeUpgradeData;
    }

    @Override
    public void parseUpgradeData(@NotNull PressurizedTubeUpgradeData data) {
        this.redstoneReactive = data.redstoneReactive;
        this.setConnectionTypesRaw(data.connectionTypes);
        this.takeChemical(data.contents, Action.EXECUTE);
    }

    @Override
    public void read(HolderLookup.Provider provider, @NotNull CompoundTag nbtTags) {
        super.read(provider, nbtTags);
        this.saveShare = nbtTags.contains("boxed_chemical", 10) ? ChemicalStack.parseOptional(provider, nbtTags.getCompound("boxed_chemical")) : ChemicalStack.EMPTY;
        this.setStackClearOthers(this.saveShare, this.chemicalTank);
    }

    private void setStackClearOthers(ChemicalStack stack, IChemicalTank tank) {
        tank.setStack(stack);
    }

    @Override
    @NotNull
    public CompoundTag write(HolderLookup.Provider provider, @NotNull CompoundTag nbtTags) {
        super.write(provider, nbtTags);
        if (this.hasTransmitterNetwork()) {
            ((ChemicalNetwork)this.getTransmitterNetwork()).validateSaveShares(this);
        }
        if (this.saveShare.isEmpty()) {
            nbtTags.remove("boxed_chemical");
        } else {
            nbtTags.put("boxed_chemical", this.saveShare.save(provider));
        }
        return nbtTags;
    }

    @Override
    public ChemicalNetwork createEmptyNetworkWithID(UUID networkID) {
        return new ChemicalNetwork(networkID);
    }

    @Override
    public ChemicalNetwork createNetworkByMerging(Collection<ChemicalNetwork> toMerge) {
        return new ChemicalNetwork(toMerge);
    }

    @Override
    public CompatibleTransmitterValidator<IChemicalHandler, ChemicalNetwork, PressurizedTube> getNewOrphanValidator() {
        return new CompatibleTransmitterValidator.CompatibleChemicalTransmitterValidator(this);
    }

    @Override
    public boolean isValidTransmitter(TileEntityTransmitter transmitter, Direction side) {
        Transmitter<?, ?, ?> transmitter2;
        if (super.isValidTransmitter(transmitter, side) && (transmitter2 = transmitter.getTransmitter()) instanceof PressurizedTube) {
            PressurizedTube other = (PressurizedTube)transmitter2;
            Holder<Chemical> buffer = PressurizedTube.getBufferOrFallback(this);
            if (buffer.is(MekanismAPI.EMPTY_CHEMICAL_KEY)) {
                return true;
            }
            Holder<Chemical> otherBuffer = PressurizedTube.getBufferOrFallback(other);
            return otherBuffer.is(MekanismAPI.EMPTY_CHEMICAL_KEY) || buffer.is(otherBuffer);
        }
        return false;
    }

    private static Holder<Chemical> getBufferOrFallback(PressurizedTube tube) {
        Holder<Chemical> buffer = tube.getBufferWithFallback().getChemicalHolder();
        if (buffer.is(MekanismAPI.EMPTY_CHEMICAL_KEY) && tube.hasTransmitterNetwork() && ((ChemicalNetwork)tube.getTransmitterNetwork()).getPrevTransferAmount() > 0L) {
            return ((ChemicalNetwork)tube.getTransmitterNetwork()).lastChemical;
        }
        return buffer;
    }

    @Override
    protected boolean canHaveIncompatibleNetworks() {
        return true;
    }

    @Override
    public long getCapacity() {
        return this.tier.getTubeCapacity();
    }

    @Override
    @NotNull
    public ChemicalStack releaseShare() {
        if (this.chemicalTank.isEmpty()) {
            return ChemicalStack.EMPTY;
        }
        ChemicalStack ret = this.chemicalTank.getStack();
        this.chemicalTank.setEmpty();
        return ret;
    }

    @Override
    @NotNull
    public ChemicalStack getShare() {
        return this.chemicalTank.getStack();
    }

    @Override
    public boolean noBufferOrFallback() {
        return this.getBufferWithFallback().isEmpty();
    }

    @Override
    @NotNull
    public ChemicalStack getBufferWithFallback() {
        ChemicalStack buffer = this.getShare();
        if (buffer.isEmpty() && this.hasTransmitterNetwork()) {
            return ((ChemicalNetwork)this.getTransmitterNetwork()).getBuffer();
        }
        return buffer;
    }

    @Override
    public void takeShare() {
        if (this.hasTransmitterNetwork()) {
            ChemicalNetwork transmitterNetwork = (ChemicalNetwork)this.getTransmitterNetwork();
            if (!transmitterNetwork.chemicalTank.isEmpty() && !this.saveShare.isEmpty()) {
                ChemicalStack chemicalStack = this.saveShare;
                long amount = chemicalStack.getAmount();
                MekanismUtils.logMismatchedStackSize(transmitterNetwork.chemicalTank.shrinkStack(amount, Action.EXECUTE), amount);
                this.setStackClearOthers(chemicalStack, this.chemicalTank);
            }
        }
    }

    private ChemicalStack takeChemical(ChemicalStack stack, Action action) {
        IChemicalTank tank = this.hasTransmitterNetwork() ? ((ChemicalNetwork)this.getTransmitterNetwork()).chemicalTank : this.chemicalTank;
        return tank.insert(stack, action, AutomationType.INTERNAL);
    }

    @Override
    @NotNull
    public List<IChemicalTank> getChemicalTanks(@Nullable Direction side) {
        if (this.hasTransmitterNetwork()) {
            return ((ChemicalNetwork)this.getTransmitterNetwork()).getChemicalTanks(side);
        }
        return this.chemicalTanks;
    }

    @Override
    public void onContentsChanged() {
        this.getTransmitterTile().setChanged();
    }

    @Override
    protected void handleContentsUpdateTag(@NotNull ChemicalNetwork network, @NotNull CompoundTag tag, @NotNull HolderLookup.Provider provider) {
        super.handleContentsUpdateTag(network, tag, provider);
        NBTUtils.setFloatIfPresent(tag, "scale", scale -> {
            network.currentScale = scale;
        });
        if (tag.contains("chemical", 8)) {
            network.setLastChemical(Chemical.parseOptionalHolder(provider, tag.getString("chemical")));
        } else {
            network.setLastChemical(MekanismAPI.EMPTY_CHEMICAL_HOLDER);
        }
    }

    public IChemicalTank getChemicalTank() {
        return this.hasTransmitterNetwork() ? ((ChemicalNetwork)this.getTransmitterNetwork()).chemicalTank : this.chemicalTank;
    }
}

