/*
 * Decompiled with CFR 0.152.
 */
package meranha.mekaweapons.items;

import java.util.List;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.energy.IStrictEnergyHandler;
import mekanism.api.security.IItemSecurityUtils;
import mekanism.api.text.EnumColor;
import mekanism.common.Mekanism;
import mekanism.common.attachments.FrequencyAware;
import mekanism.common.capabilities.ICapabilityAware;
import mekanism.common.capabilities.security.OwnerObject;
import mekanism.common.content.entangloporter.InventoryFrequency;
import mekanism.common.integration.curios.CuriosIntegration;
import mekanism.common.integration.energy.EnergyCompatUtils;
import mekanism.common.item.interfaces.IGuiItem;
import mekanism.common.lib.frequency.Frequency;
import mekanism.common.lib.frequency.FrequencyType;
import mekanism.common.lib.frequency.IFrequencyItem;
import mekanism.common.lib.security.ItemSecurityUtils;
import mekanism.common.registration.impl.ContainerTypeRegistryObject;
import mekanism.common.registries.MekanismDataComponents;
import mekanism.common.util.MekanismUtils;
import meranha.mekaweapons.MekaWeapons;
import meranha.mekaweapons.client.WeaponsLang;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class ItemMagnetizer
extends Item
implements IFrequencyItem,
IGuiItem,
ICapabilityAware {
    public ItemMagnetizer(@NotNull Item.Properties pProperties) {
        super(pProperties.rarity(Rarity.RARE).stacksTo(1));
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        IItemSecurityUtils.INSTANCE.addSecurityTooltip(stack, tooltip);
        MekanismUtils.addFrequencyItemTooltip((ItemStack)stack, tooltip);
        tooltip.add((Component)WeaponsLang.MAGNETIZER.translateColored(EnumColor.WHITE));
    }

    public void inventoryTick(@NotNull ItemStack stack, Level level, @NotNull Entity entity, int slotId, boolean isSelected) {
        Frequency frequency;
        if (level.isClientSide() || !(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        FrequencyAware frequencyAware = (FrequencyAware)stack.get(this.getFrequencyComponent());
        if (frequencyAware == null || !((frequency = frequencyAware.getFrequency(stack, this.getFrequencyComponent())) instanceof InventoryFrequency)) {
            return;
        }
        InventoryFrequency frequency2 = (InventoryFrequency)frequency;
        IEnergyContainer frequencyContainer = frequency2.storedEnergy;
        long toCharge = Math.min(MekaWeapons.general.wirelessChargerEnergyRate.get(), frequencyContainer.getEnergy());
        if (toCharge == 0L) {
            return;
        }
        for (ItemStack slot : player.getInventory().items) {
            toCharge = this.charge(frequencyContainer, slot, toCharge);
            if (toCharge != 0L) continue;
            return;
        }
        if (Mekanism.hooks.curios.isLoaded()) {
            IItemHandler handler = CuriosIntegration.getCuriosInventory((LivingEntity)player);
            if (handler == null) {
                return;
            }
            int slots = handler.getSlots();
            for (int slot = 0; slot < slots; ++slot) {
                toCharge = this.charge(frequencyContainer, handler.getStackInSlot(slot), toCharge);
                if (toCharge != 0L) continue;
                return;
            }
        }
    }

    private long charge(IEnergyContainer energyContainer, ItemStack stack, long amount) {
        long remaining;
        IStrictEnergyHandler handler;
        if (!stack.isEmpty() && amount > 0L && (handler = EnergyCompatUtils.getStrictEnergyHandler((ItemStack)stack)) != null && (remaining = handler.insertEnergy(amount, Action.SIMULATE)) < amount) {
            long toExtract = amount - remaining;
            long extracted = energyContainer.extract(toExtract, Action.EXECUTE, AutomationType.MANUAL);
            long inserted = handler.insertEnergy(extracted, Action.EXECUTE);
            return inserted + remaining;
        }
        return amount;
    }

    public FrequencyType<?> getFrequencyType() {
        return FrequencyType.INVENTORY;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level world, @NotNull Player player, @NotNull InteractionHand hand) {
        return ItemSecurityUtils.get().claimOrOpenGui(world, player, hand, (arg_0, arg_1, arg_2) -> this.getContainerType().tryOpenGui(arg_0, arg_1, arg_2));
    }

    public ContainerTypeRegistryObject<?> getContainerType() {
        return MekaWeapons.MAGNETIZER_CONTAINER;
    }

    public void attachCapabilities(RegisterCapabilitiesEvent event) {
        event.registerItem(IItemSecurityUtils.INSTANCE.ownerCapability(), (stack, ctx) -> new OwnerObject(stack), new ItemLike[]{this});
    }

    @NotNull
    public DataComponentType<FrequencyAware<InventoryFrequency>> getFrequencyComponent() {
        return (DataComponentType)MekanismDataComponents.INVENTORY_FREQUENCY.get();
    }
}

