/*
 * Decompiled with CFR 0.152.
 */
package meranha.mekaweapons.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import meranha.mekaweapons.MekaWeapons;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.client.ICurioRenderer;

public class WeaponsRenderer
implements ICurioRenderer {
    private static final int ROTATION_ZN_DEFAULT = -180;
    private static final int ROTATION_XP_DEFAULT = 180;
    private static final int ROTATION_XP_KATANA_BOW = 180;
    private static final int ROTATION_ZN_KATANA_BOW = 45;
    private static final float SCALE_X = 1.0f;
    private static final float SCALE_Y = -1.0f;
    private static final float SCALE_Z = -1.0f;
    private static final float TRANSLATION_Z = -0.2f;
    private static final ItemStack MEKA_TANA = MekaWeapons.MEKA_TANA.asStack();
    private static final ItemStack MEKA_BOW = MekaWeapons.MEKA_BOW.asStack();

    public <T extends LivingEntity, M extends EntityModel<T>> void render(ItemStack stack, @NotNull SlotContext slotContext, PoseStack ms, RenderLayerParent<T, M> renderLayerParent, MultiBufferSource buffer, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        LivingEntity livingEntity = slotContext.entity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        this.renderItem(stack, ms, buffer, (LivingEntity)player, -180, 180, 0.0, 0.25, -0.1, 0.6f, -0.6f, -2.0f);
        if (!player.isHolding(MEKA_TANA.getItem()) && this.contains(player, MEKA_TANA)) {
            this.renderItem(MEKA_TANA, ms, buffer, (LivingEntity)player, 45, 180, -0.1, -0.7, -0.2f, 1.0f, -1.0f, -1.0f);
        }
        if (!player.isHolding(MEKA_BOW.getItem()) && this.contains(player, MEKA_BOW)) {
            this.renderItem(MEKA_BOW, ms, buffer, (LivingEntity)player, 45, 180, -0.3, -0.1, -0.2f, 1.0f, -1.0f, -1.0f);
        }
    }

    private void renderItem(ItemStack stack, @NotNull PoseStack ms, MultiBufferSource buffer, @NotNull LivingEntity player, int rotationZN, int rotationXP, double translateX, double translateY, double translateZ, float scaleX, float scaleY, float scaleZ) {
        ms.pushPose();
        ms.mulPose(Axis.ZN.rotationDegrees((float)rotationZN));
        ms.mulPose(Axis.XP.rotationDegrees((float)rotationXP));
        ms.translate(translateX, translateY, translateZ);
        ms.scale(scaleX, scaleY, scaleZ);
        Minecraft.getInstance().getItemRenderer().renderStatic(stack, ItemDisplayContext.NONE, 0xF000F0, OverlayTexture.NO_OVERLAY, ms, buffer, player.level(), 1);
        ms.popPose();
    }

    public boolean contains(@NotNull Player player, ItemStack stack) {
        return player.getInventory().items.stream().anyMatch(item -> !item.isEmpty() && ItemStack.isSameItem((ItemStack)stack, (ItemStack)item));
    }
}

