/*
 * Decompiled with CFR 0.152.
 */
package meranha.mekaweapons;

import java.lang.runtime.SwitchBootstraps;
import java.util.Locale;
import java.util.Objects;
import java.util.function.IntFunction;
import mekanism.api.IIncrementalEnum;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.gear.ICustomModule;
import mekanism.api.gear.IModule;
import mekanism.api.gear.IModuleHelper;
import mekanism.api.gear.ModuleData;
import mekanism.api.radial.IRadialDataHelper;
import mekanism.api.radial.mode.BasicRadialMode;
import mekanism.api.radial.mode.IRadialMode;
import mekanism.api.text.EnumColor;
import mekanism.api.text.IHasTextComponent;
import mekanism.api.text.ILangEntry;
import mekanism.api.text.TextComponentUtil;
import mekanism.common.config.MekanismConfig;
import mekanism.common.config.value.CachedIntValue;
import mekanism.common.config.value.CachedLongValue;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StorageUtils;
import meranha.mekaweapons.MekaWeapons;
import meranha.mekaweapons.client.WeaponsLang;
import meranha.mekaweapons.items.ItemMekaBow;
import meranha.mekaweapons.items.ItemMekaTana;
import meranha.mekaweapons.items.modules.WeaponAttackAmplificationUnit;
import meranha.mekaweapons.items.modules.WeaponsModules;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.TranslatableEnum;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MekaWeaponsUtils {
    public static long getBaseEnergyUsage(@NotNull ItemStack stack) {
        Item item = stack.getItem();
        Objects.requireNonNull(item);
        Item item2 = item;
        int n = 0;
        CachedLongValue energy = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ItemMekaBow.class, ItemMekaTana.class}, (Object)item2, n)) {
            case 0 -> {
                ItemMekaBow ignored = (ItemMekaBow)item2;
                yield MekaWeapons.general.mekaBowEnergyUsage;
            }
            case 1 -> {
                ItemMekaTana ignored = (ItemMekaTana)item2;
                yield MekaWeapons.general.mekaTanaEnergyUsage;
            }
            default -> null;
        };
        return energy != null ? energy.get() : 0L;
    }

    public static long getEnergyNeeded(@Nullable ItemStack weaponStack) {
        if (weaponStack == null) {
            return -1L;
        }
        long energy = MekaWeaponsUtils.getBaseEnergyUsage(weaponStack);
        if (weaponStack.getItem() instanceof ItemMekaBow) {
            IModule drawSpeedUnit;
            if (MekaWeaponsUtils.isModuleEnabled(weaponStack, WeaponsModules.ARROWENERGY_UNIT)) {
                energy += MekaWeapons.general.mekaBowEnergyArrowUsage.get();
            }
            if (MekaWeaponsUtils.isModuleEnabled(weaponStack, WeaponsModules.AUTOFIRE_UNIT)) {
                energy += MekaWeapons.general.mekabowAutoFireEnergyUsage.get();
            }
            if (MekaWeaponsUtils.isModuleEnabled(weaponStack, WeaponsModules.GRAVITYDAMPENER_UNIT)) {
                energy += MekaWeapons.general.mekabowGravityDampenerUsage.get();
            }
            if ((drawSpeedUnit = MekaWeaponsUtils.getEnabledModule(weaponStack, WeaponsModules.DRAWSPEED_UNIT)) != null) {
                energy += (long)drawSpeedUnit.getInstalledCount() * MekaWeapons.general.mekabowDrawSpeedUsage.get();
            }
            if (MekaWeaponsUtils.isModuleEnabled(weaponStack, WeaponsModules.LOOTING_UNIT)) {
                energy += MekaWeapons.general.mekaBowLootingEnergyUsage.get();
            }
        } else if (weaponStack.getItem() instanceof ItemMekaTana) {
            if (MekaWeaponsUtils.isModuleEnabled(weaponStack, WeaponsModules.SWEEPING_UNIT)) {
                energy += MekaWeapons.general.mekaTanaSweepingEnergyUsage.get();
            }
            if (MekaWeaponsUtils.isModuleEnabled(weaponStack, WeaponsModules.LOOTING_UNIT)) {
                energy += MekaWeapons.general.mekaTanaLootingEnergyUsage.get();
            }
        }
        IModule attackAmplificationUnit = MekaWeaponsUtils.getEnabledModule(weaponStack, WeaponsModules.ATTACKAMPLIFICATION_UNIT);
        if (attackAmplificationUnit != null) {
            energy *= (long)((WeaponAttackAmplificationUnit)attackAmplificationUnit.getCustomInstance()).getCurrentUnit();
        }
        return energy;
    }

    public static int getBarCustomColor(@NotNull ItemStack stack) {
        if (MekaWeaponsUtils.isEnergyInsufficient(stack)) {
            return MekanismConfig.client.hudDangerColor.get();
        }
        return MekanismConfig.client.energyColor.get();
    }

    public static int getBaseDamage(@NotNull ItemStack stack) {
        Item item = stack.getItem();
        Objects.requireNonNull(item);
        Item item2 = item;
        int n = 0;
        CachedIntValue damage = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ItemMekaBow.class, ItemMekaTana.class}, (Object)item2, n)) {
            case 0 -> {
                ItemMekaBow ignored = (ItemMekaBow)item2;
                yield MekaWeapons.general.mekaBowBaseDamage;
            }
            case 1 -> {
                ItemMekaTana ignored = (ItemMekaTana)item2;
                yield MekaWeapons.general.mekaTanaBaseDamage;
            }
            default -> null;
        };
        return damage != null ? damage.get() : 0;
    }

    public static long getTotalDamage(@NotNull ItemStack weapon) {
        if (MekaWeaponsUtils.isEnergyInsufficient(weapon)) {
            return 20L;
        }
        long damage = MekaWeaponsUtils.getBaseDamage(weapon);
        IModule attackAmplificationUnit = MekaWeaponsUtils.getEnabledModule(weapon, WeaponsModules.ATTACKAMPLIFICATION_UNIT);
        if (attackAmplificationUnit != null) {
            damage *= (long)((WeaponAttackAmplificationUnit)attackAmplificationUnit.getCustomInstance()).getCurrentUnit();
        }
        return damage;
    }

    public static boolean isEnergyInsufficient(@Nullable IEnergyContainer energyContainer, long energyNeeded) {
        return energyContainer == null || energyContainer.getEnergy() < energyNeeded;
    }

    public static boolean isEnergyInsufficient(@NotNull ItemStack weapon) {
        return MekaWeaponsUtils.isEnergyInsufficient(StorageUtils.getEnergyContainer((ItemStack)weapon, (int)0), MekaWeaponsUtils.getEnergyNeeded(weapon));
    }

    @Nullable
    public static <MODULE extends ICustomModule<MODULE>> IModule<MODULE> getEnabledModule(ItemStack stack, DeferredHolder<ModuleData<?>, ModuleData<MODULE>> type) {
        return IModuleHelper.INSTANCE.getIfEnabled(stack, type);
    }

    public static boolean isModuleEnabled(ItemStack stack, Holder<ModuleData<?>> type) {
        return IModuleHelper.INSTANCE.isEnabled(stack, type);
    }

    @NothingNullByDefault
    public static enum ToggleableModule implements IIncrementalEnum<ToggleableModule>,
    IHasTextComponent,
    TranslatableEnum,
    IRadialMode,
    StringRepresentable
    {
        OFF(WeaponsLang.RADIAL_TOGGLE_OFF, EnumColor.WHITE, "off"),
        ON(WeaponsLang.RADIAL_TOGGLE_ON, EnumColor.BRIGHT_GREEN, "on");

        private final String serializedName = this.name().toLowerCase(Locale.ROOT);
        private final ResourceLocation icon;
        private final Component label;
        private final EnumColor color;
        private final Component sliceNamePreCalc;
        public static final IntFunction<ToggleableModule> BY_ID;
        public static final IRadialDataHelper.BooleanRadialModes RADIAL_MODES;

        private ToggleableModule(ILangEntry langEntry, EnumColor color, String texture) {
            this.color = color;
            this.icon = MekaWeapons.getResource(MekanismUtils.ResourceType.GUI_RADIAL, texture + ".png");
            this.label = TextComponentUtil.getString((String)Integer.toString(this.ordinal()));
            this.sliceNamePreCalc = langEntry.translateColored(color);
        }

        public ToggleableModule byIndex(int index) {
            return BY_ID.apply(index);
        }

        public Component getTextComponent() {
            return this.label;
        }

        public Component getTranslatedName() {
            return this.sliceName();
        }

        public Component sliceName() {
            return this.sliceNamePreCalc;
        }

        public ResourceLocation icon() {
            return this.icon;
        }

        public EnumColor color() {
            return this.color;
        }

        public String getSerializedName() {
            return this.serializedName;
        }

        static {
            BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])ToggleableModule.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
            RADIAL_MODES = new IRadialDataHelper.BooleanRadialModes((IRadialMode)new BasicRadialMode((ILangEntry)WeaponsLang.RADIAL_TOGGLE_OFF, OFF.icon(), EnumColor.RED), (IRadialMode)new BasicRadialMode((ILangEntry)WeaponsLang.RADIAL_TOGGLE_ON, ON.icon(), EnumColor.BRIGHT_GREEN));
        }
    }
}

