/*
 * Decompiled with CFR 0.152.
 */
package mrbysco.constructionstick.data;

import java.util.concurrent.CompletableFuture;
import mrbysco.constructionstick.data.client.ItemModelGenerator;
import mrbysco.constructionstick.data.client.LanguageGenerator;
import mrbysco.constructionstick.data.server.AdvancementGenerator;
import mrbysco.constructionstick.data.server.BlockTagsGenerator;
import mrbysco.constructionstick.data.server.ItemTagsGenerator;
import mrbysco.constructionstick.data.server.RecipeGenerator;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class ModData {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        if (event.includeServer()) {
            BlockTagsGenerator blockTags = new BlockTagsGenerator(packOutput, lookupProvider, fileHelper);
            generator.addProvider(true, (DataProvider)blockTags);
            generator.addProvider(true, (DataProvider)new ItemTagsGenerator(packOutput, lookupProvider, (TagsProvider<Block>)blockTags, fileHelper));
            generator.addProvider(true, (DataProvider)new RecipeGenerator(packOutput, lookupProvider));
            generator.addProvider(true, (DataProvider)new AdvancementGenerator(packOutput, lookupProvider, fileHelper));
        }
        if (event.includeClient()) {
            generator.addProvider(true, (DataProvider)new LanguageGenerator(packOutput));
            generator.addProvider(true, (DataProvider)new ItemModelGenerator(packOutput, fileHelper));
        }
    }
}

