/*
 * Decompiled with CFR 0.152.
 */
package com.ultramega.cabletiers.common.constructordestructor;

import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.resource.filter.FilterMode;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.constructordestructor.DestructorStrategy;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceContainer;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeDestination;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeItem;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeState;
import com.refinedmods.refinedstorage.common.content.Items;
import com.refinedmods.refinedstorage.common.support.BlockEntityWithDrops;
import com.refinedmods.refinedstorage.common.support.FilterModeSettings;
import com.refinedmods.refinedstorage.common.support.containermenu.NetworkNodeExtendedMenuProvider;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerData;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeContainer;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeDestinations;
import com.ultramega.cabletiers.common.CableTiers;
import com.ultramega.cabletiers.common.CableType;
import com.ultramega.cabletiers.common.TieredUpgradeDestinations;
import com.ultramega.cabletiers.common.advancedfilter.AdvancedResourceContainerImpl;
import com.ultramega.cabletiers.common.advancedfilter.TagFilterWithFuzzyMode;
import com.ultramega.cabletiers.common.constructordestructor.CompositeDestructorStrategy;
import com.ultramega.cabletiers.common.constructordestructor.TieredDestructorContainerMenu;
import com.ultramega.cabletiers.common.constructordestructor.TieredDestructorNetworkNode;
import com.ultramega.cabletiers.common.registry.BlockEntities;
import com.ultramega.cabletiers.common.support.AbstractTieredCableLikeBlockEntity;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamEncoder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class AbstractTieredDestructorBlockEntity
extends AbstractTieredCableLikeBlockEntity<TieredDestructorNetworkNode>
implements NetworkNodeExtendedMenuProvider<ResourceContainerData>,
BlockEntityWithDrops {
    private static final String TAG_PICKUP_ITEMS = "pi";
    private boolean pickupItems;

    protected AbstractTieredDestructorBlockEntity(final CableTiers tier, BlockPos pos, BlockState state) {
        super(BlockEntities.INSTANCE.getTieredDestructors(tier), pos, state, new TieredDestructorNetworkNode(tier.getEnergyUsage(CableType.DESTRUCTOR)), tier, CableType.DESTRUCTOR);
        this.filter = TagFilterWithFuzzyMode.createAndListenForUniqueFilters(AdvancedResourceContainerImpl.createForFilter(tier), this::setChanged, this::setFilters);
        this.upgradeContainer = new UpgradeContainer(this, AbstractTieredDestructorBlockEntity.getUpgradeDestination(tier), (c, upgradeEnergyUsage) -> {
            ((TieredDestructorNetworkNode)this.mainNetworkNode).setEnergyUsage(tier.getEnergyUsage(CableType.DESTRUCTOR) + upgradeEnergyUsage);
            this.setChanged();
            Level patt0$temp = this.level;
            if (patt0$temp instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)patt0$temp;
                this.initialize(serverLevel);
            }
        }, Math.max(1, 20 - tier.getSpeed(CableType.DESTRUCTOR))){

            public int getAmount(UpgradeItem upgradeItem) {
                if (tier == CableTiers.CREATIVE && upgradeItem == Items.INSTANCE.getSpeedUpgrade()) {
                    return 4;
                }
                return super.getAmount(upgradeItem);
            }
        };
        this.ticker = this.upgradeContainer.getTicker();
    }

    public static UpgradeDestination getUpgradeDestination(CableTiers tier) {
        return tier == CableTiers.CREATIVE ? TieredUpgradeDestinations.DESTRUCTOR_NO_SPEED : UpgradeDestinations.DESTRUCTOR;
    }

    public boolean isPickupItems() {
        return this.pickupItems;
    }

    public void setPickupItems(boolean pickupItems) {
        this.pickupItems = pickupItems;
        this.setChanged();
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.initialize(serverLevel);
        }
    }

    void setFilters(Set<ResourceKey> filters, Set<TagKey<?>> tagFilters) {
        ((TieredDestructorNetworkNode)this.mainNetworkNode).setFilters(filters, tagFilters);
    }

    public FilterMode getFilterMode() {
        return ((TieredDestructorNetworkNode)this.mainNetworkNode).getFilterMode();
    }

    public void setFilterMode(FilterMode mode) {
        ((TieredDestructorNetworkNode)this.mainNetworkNode).setFilterMode(mode);
        this.setChanged();
    }

    @Override
    public void writeConfiguration(CompoundTag tag, HolderLookup.Provider provider) {
        super.writeConfiguration(tag, provider);
        tag.putInt("fim", FilterModeSettings.getFilterMode((FilterMode)((TieredDestructorNetworkNode)this.mainNetworkNode).getFilterMode()));
        tag.putBoolean(TAG_PICKUP_ITEMS, this.pickupItems);
    }

    @Override
    public void readConfiguration(CompoundTag tag, HolderLookup.Provider provider) {
        super.readConfiguration(tag, provider);
        if (tag.contains("fim")) {
            ((TieredDestructorNetworkNode)this.mainNetworkNode).setFilterMode(FilterModeSettings.getFilterMode((int)tag.getInt("fim")));
        }
        if (tag.contains(TAG_PICKUP_ITEMS)) {
            this.pickupItems = tag.getBoolean(TAG_PICKUP_ITEMS);
        }
    }

    protected void initialize(ServerLevel level, Direction direction) {
        super.initialize(level, direction);
        ((TieredDestructorNetworkNode)this.mainNetworkNode).setPlayerProvider(() -> this.getFakePlayer(level));
        ((TieredDestructorNetworkNode)this.mainNetworkNode).setStrategy(this.createStrategy(level, direction));
    }

    private CompositeDestructorStrategy createStrategy(ServerLevel level, Direction direction) {
        BlockPos pos = this.getBlockPos().relative(direction);
        Direction incomingDirection = direction.getOpposite();
        List<DestructorStrategy> strategies = RefinedStorageApi.INSTANCE.getDestructorStrategyFactories().stream().flatMap(factory -> factory.create(level, pos, incomingDirection, (UpgradeState)this.upgradeContainer, this.pickupItems).stream()).toList();
        return new CompositeDestructorStrategy(strategies);
    }

    public ResourceContainerData getMenuData() {
        return ResourceContainerData.of((ResourceContainer)this.filter.getFilterContainer());
    }

    public StreamEncoder<RegistryFriendlyByteBuf, ResourceContainerData> getMenuCodec() {
        return ResourceContainerData.STREAM_CODEC;
    }

    public Component getName() {
        return this.overrideName((Component)this.tier.getContentName(CableType.DESTRUCTOR));
    }

    @Nullable
    public AbstractContainerMenu createMenu(int syncId, Inventory inventory, Player player) {
        this.setInContainerMenu(true);
        return new TieredDestructorContainerMenu(syncId, player, this, (ResourceContainer)this.filter.getFilterContainer(), this.upgradeContainer, this.tier);
    }
}

