/*
 * Decompiled with CFR 0.152.
 */
package com.heaser.pipeconnector.compatibility.ae2;

import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartItem;
import appeng.api.parts.PartHelper;
import appeng.block.networking.CableBusBlock;
import appeng.core.definitions.AEBlocks;
import appeng.items.parts.ColoredPartItem;
import appeng.items.parts.PartItem;
import com.heaser.pipeconnector.compatibility.interfaces.IBlockEqualsChecker;
import com.heaser.pipeconnector.compatibility.interfaces.IBlockGetter;
import com.heaser.pipeconnector.compatibility.interfaces.IDirectionGetter;
import com.heaser.pipeconnector.compatibility.interfaces.IPlacer;
import com.heaser.pipeconnector.utils.GeneralUtils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class AE2Compatiblity
implements IBlockGetter,
IPlacer,
IBlockEqualsChecker,
IDirectionGetter {
    public static Class<? extends Item> getItemStackClassToRegister() {
        return PartItem.class;
    }

    public static Class<? extends Block> getBlockToRegister() {
        return CableBusBlock.class;
    }

    @Override
    public Block getBlock(ItemStack placedStack) {
        return AEBlocks.CABLE_BUS.block();
    }

    @Override
    public boolean place(Level level, BlockPos pos, Player player, Item item, List<Direction> adjacentDirectionSides, ItemStack heldPipeItem) {
        IPart part = null;
        if (item instanceof IPartItem) {
            IPartHost host;
            IPartItem partItem = (IPartItem)item;
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof IPartHost ? (host = (IPartHost)blockEntity).getPart(null) != null : !GeneralUtils.isVoidableBlock(level, pos)) {
                BlockState state = level.getBlockState(pos);
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    List drops = Block.getDrops((BlockState)state, (ServerLevel)serverLevel, (BlockPos)pos, (BlockEntity)blockEntity, (Entity)player, (ItemStack)heldPipeItem);
                    for (ItemStack drop : drops) {
                        if (player.getInventory().add(drop)) continue;
                        player.drop(drop, false);
                    }
                    serverLevel.sendParticles((ParticleOptions)ParticleTypes.POOF, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 5, 0.1, 0.1, 0.1, 0.05);
                    level.playSound(null, pos, SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, ((player.getRandom().nextFloat() - player.getRandom().nextFloat()) * 0.7f + 1.0f) * 2.0f);
                }
                level.removeBlock(pos, false);
            }
            part = PartHelper.setPart((ServerLevel)((ServerLevel)level), (BlockPos)pos, null, (Player)player, (IPartItem)partItem);
        }
        return part != null;
    }

    @Override
    public boolean isBlockStateSpecificBlock(BlockPos pos, Block specificBlock, ItemStack placedItemStack, Level level) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        Item placedItem = placedItemStack.getItem();
        if (level.getBlockState(pos).getBlock() instanceof CableBusBlock && blockEntity instanceof IPartHost) {
            IPartHost host = (IPartHost)blockEntity;
            if (placedItem instanceof IPartItem) {
                IPart part = host.getPart(null);
                if (part == null) {
                    return false;
                }
                IPartItem partItem = part.getPartItem();
                boolean colorsEqual = true;
                if (partItem instanceof ColoredPartItem) {
                    ColoredPartItem coloredPartItem = (ColoredPartItem)partItem;
                    if (placedItem instanceof ColoredPartItem) {
                        ColoredPartItem coloredPlacedItem = (ColoredPartItem)placedItem;
                        colorsEqual = coloredPartItem.getColor().equals((Object)coloredPlacedItem.getColor());
                    }
                }
                Class ownClass = ((IPartItem)placedItem).getPartClass();
                Class targetClass = partItem.getPartClass();
                return colorsEqual && targetClass == ownClass;
            }
        }
        return false;
    }

    @Override
    public boolean isPlacementAlreadySatisfied(BlockPos pos, Block specificBlock, ItemStack placedItemStack, Level level) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        Item placedItem = placedItemStack.getItem();
        if (level.getBlockState(pos).getBlock() instanceof CableBusBlock && blockEntity instanceof IPartHost) {
            IPartHost host = (IPartHost)blockEntity;
            if (placedItem instanceof IPartItem) {
                IPart part = host.getPart(null);
                if (part == null) {
                    return false;
                }
                IPartItem partItem = part.getPartItem();
                boolean colorsEqual = true;
                if (partItem instanceof ColoredPartItem) {
                    ColoredPartItem coloredPartItem = (ColoredPartItem)partItem;
                    if (placedItem instanceof ColoredPartItem) {
                        ColoredPartItem coloredPlacedItem = (ColoredPartItem)placedItem;
                        colorsEqual = coloredPartItem.getColor().equals((Object)coloredPlacedItem.getColor());
                    }
                }
                Class ownClass = ((IPartItem)placedItem).getPartClass();
                Class targetClass = partItem.getPartClass();
                return colorsEqual && targetClass == ownClass;
            }
        }
        return false;
    }

    @Override
    public boolean isPassableForPathfinding(BlockPos pos, Level level, ItemStack placedItemStack) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (level.getBlockState(pos).getBlock() instanceof CableBusBlock && blockEntity instanceof IPartHost) {
            IPartHost host = (IPartHost)blockEntity;
            return host.getPart(null) == null;
        }
        return false;
    }

    @Override
    @Nullable
    public Direction getDirection(UseOnContext context) {
        IPartHost host;
        BlockPos clickedPosition = context.getClickedPos();
        Level level = context.getLevel();
        BlockEntity blockEntity = level.getBlockEntity(clickedPosition);
        if (blockEntity instanceof IPartHost && (host = (IPartHost)blockEntity).getPart(null) == null) {
            return null;
        }
        return context.getClickedFace();
    }
}

