/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinerypnc.common.requirement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.api.crafting.CraftingResult;
import fr.frinn.custommachinery.api.crafting.ICraftingContext;
import fr.frinn.custommachinery.api.crafting.IMachineRecipe;
import fr.frinn.custommachinery.api.crafting.IRequirementList;
import fr.frinn.custommachinery.api.integration.jei.IJEIIngredientRequirement;
import fr.frinn.custommachinery.api.integration.jei.IJEIIngredientWrapper;
import fr.frinn.custommachinery.api.requirement.IRequirement;
import fr.frinn.custommachinery.api.requirement.RecipeRequirement;
import fr.frinn.custommachinery.api.requirement.RequirementIOMode;
import fr.frinn.custommachinery.api.requirement.RequirementType;
import fr.frinn.custommachinerypnc.client.jei.pressure.Pressure;
import fr.frinn.custommachinerypnc.client.jei.pressure.PressureJeiIngredientWrapper;
import fr.frinn.custommachinerypnc.common.Registration;
import fr.frinn.custommachinerypnc.common.component.PressureMachineComponent;
import java.util.Collections;
import java.util.List;
import net.minecraft.network.chat.Component;

public record PressureRequirement(RequirementIOMode mode, float minPressure, float maxPressure, int volume) implements IRequirement<PressureMachineComponent>,
IJEIIngredientRequirement<Pressure>
{
    public static final NamedCodec<PressureRequirement> CODEC = NamedCodec.record(pressureRequirementInstance -> pressureRequirementInstance.group((App)RequirementIOMode.CODEC.fieldOf("mode").forGetter(requirement -> requirement.mode), (App)NamedCodec.FLOAT.optionalFieldOf("min", (Object)Float.valueOf(-1.0f)).forGetter(requirement -> Float.valueOf(requirement.minPressure)), (App)NamedCodec.FLOAT.optionalFieldOf("max", (Object)Float.valueOf(25.0f)).forGetter(requirement -> Float.valueOf(requirement.maxPressure)), (App)NamedCodec.INT.optionalFieldOf("volume", (Object)0).forGetter(requirement -> requirement.volume)).apply((Applicative)pressureRequirementInstance, PressureRequirement::new), (String)"Pressure requirement");

    public RequirementType<PressureRequirement> getType() {
        return Registration.PRESSURE_REQUIREMENT.get();
    }

    public MachineComponentType<PressureMachineComponent> getComponentType() {
        return Registration.PRESSURE_COMPONENT.get();
    }

    public RequirementIOMode getMode() {
        return this.mode;
    }

    public boolean test(PressureMachineComponent component, ICraftingContext context) {
        return this.mode == RequirementIOMode.OUTPUT || this.check(component, context).isSuccess();
    }

    public void gatherRequirements(IRequirementList<PressureMachineComponent> list) {
        if (this.mode == RequirementIOMode.OUTPUT) {
            list.processOnEnd(this::output);
        } else {
            list.inventoryCondition(this::check);
            list.processOnStart(this::input);
        }
    }

    private CraftingResult check(PressureMachineComponent component, ICraftingContext context) {
        if (component.getHandler().getPressure() < this.minPressure) {
            return CraftingResult.error((Component)Component.translatable((String)"custommachinerypnc.requirements.pressure.error.min", (Object[])new Object[]{Float.valueOf(this.minPressure)}));
        }
        if (component.getHandler().getPressure() > this.maxPressure) {
            return CraftingResult.error((Component)Component.translatable((String)"custommachinerypnc.requirements.pressure.error.max", (Object[])new Object[]{Float.valueOf(this.maxPressure)}));
        }
        return CraftingResult.success();
    }

    private CraftingResult input(PressureMachineComponent component, ICraftingContext context) {
        int volume = (int)context.getIntegerModifiedValue((double)this.volume, (IRequirement)this, "");
        if (component.getHandler().getAir() < volume) {
            return CraftingResult.error((Component)Component.translatable((String)"custommachinerypnc.requirements.pressure.error.air", (Object[])new Object[]{volume, component.getHandler().getAir()}));
        }
        component.getHandler().addAir(-volume);
        return CraftingResult.success();
    }

    private CraftingResult output(PressureMachineComponent component, ICraftingContext context) {
        int volume = (int)context.getIntegerModifiedValue((double)this.volume, (IRequirement)this, "");
        component.getHandler().addAir(volume);
        return CraftingResult.success();
    }

    public List<IJEIIngredientWrapper<Pressure>> getJEIIngredientWrappers(IMachineRecipe recipe, RecipeRequirement<?, ?> requirement) {
        return Collections.singletonList(new PressureJeiIngredientWrapper(this.mode, new Pressure(this.minPressure, this.maxPressure, this.volume)));
    }
}

