/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinerypnc.common.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.api.component.ComponentIOMode;
import fr.frinn.custommachinery.api.component.IMachineComponentManager;
import fr.frinn.custommachinery.api.component.IMachineComponentTemplate;
import fr.frinn.custommachinery.api.component.ISerializableComponent;
import fr.frinn.custommachinery.api.component.ISideConfigComponent;
import fr.frinn.custommachinery.api.component.ITickableComponent;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.api.network.ISyncable;
import fr.frinn.custommachinery.api.network.ISyncableStuff;
import fr.frinn.custommachinery.common.network.syncable.FloatSyncable;
import fr.frinn.custommachinery.common.network.syncable.ToggleSideConfigSyncable;
import fr.frinn.custommachinery.impl.component.AbstractMachineComponent;
import fr.frinn.custommachinery.impl.component.config.ToggleSideConfig;
import fr.frinn.custommachinery.impl.component.config.ToggleSideMode;
import fr.frinn.custommachinerypnc.common.Registration;
import java.util.Arrays;
import java.util.function.Consumer;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.pressure.PressureTier;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerMachine;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;

public class PressureMachineComponent
extends AbstractMachineComponent
implements ISerializableComponent,
ITickableComponent,
ISideConfigComponent,
ISyncableStuff {
    private final IAirHandlerMachine handler;
    private final ToggleSideConfig config;
    private int prevAir = 0;

    public PressureMachineComponent(IMachineComponentManager manager, int volume, float danger, float critical, ToggleSideConfig.Template config) {
        super(manager, ComponentIOMode.BOTH);
        this.handler = PneumaticRegistry.getInstance().getAirHandlerMachineFactory().createAirHandler((PressureTier)new CustomPressureTier(danger, critical), volume);
        this.upgradeableI(volume, "volume", 0, Integer.MIN_VALUE, arg_0 -> ((IAirHandlerMachine)this.handler).setBaseVolume(arg_0));
        this.config = config.build((ISideConfigComponent)this);
        this.config.setCallback((side, oldMode, newMode) -> this.refreshConnectableFaces());
        this.handler.setConnectableFaces(Arrays.stream(Direction.values()).filter(side -> ((ToggleSideMode)this.config.getDirectionMode(side)).isEnabled()).toList());
    }

    private void refreshConnectableFaces() {
        this.handler.setConnectableFaces(Arrays.stream(Direction.values()).filter(side -> ((ToggleSideMode)this.config.getDirectionMode(side)).isEnabled()).toList());
        this.getManager().getTile().invalidateCapabilities();
        this.getManager().getLevel().updateNeighborsAt(this.getManager().getTile().getBlockPos(), this.getManager().getTile().getBlockState().getBlock());
    }

    public IAirHandlerMachine getHandler() {
        return this.handler;
    }

    public MachineComponentType<PressureMachineComponent> getType() {
        return Registration.PRESSURE_COMPONENT.get();
    }

    public void serverTick() {
        this.handler.tick((BlockEntity)this.getManager().getTile());
        if (this.prevAir != this.handler.getAir()) {
            this.getManager().markDirty();
        }
        this.prevAir = this.handler.getAir();
    }

    public void clientTick() {
        this.handler.tick((BlockEntity)this.getManager().getTile());
    }

    public void serialize(CompoundTag nbt, HolderLookup.Provider registries) {
        nbt.put("pressure", this.handler.serializeNBT());
    }

    public void deserialize(CompoundTag nbt, HolderLookup.Provider registries) {
        if (nbt.contains("pressure", 10)) {
            this.handler.deserializeNBT(nbt.getCompound("pressure"));
        }
    }

    public ToggleSideConfig getConfig() {
        return this.config;
    }

    public String getId() {
        return "pressure";
    }

    public void getStuffToSync(Consumer<ISyncable<?, ?>> container) {
        container.accept((ISyncable<?, ?>)FloatSyncable.create(() -> ((IAirHandlerMachine)this.handler).getPressure(), arg_0 -> ((IAirHandlerMachine)this.handler).setPressure(arg_0)));
        container.accept((ISyncable<?, ?>)ToggleSideConfigSyncable.create(this::getConfig, arg_0 -> ((ToggleSideConfig)this.config).set(arg_0)));
    }

    public record CustomPressureTier(float danger, float critical) implements PressureTier
    {
        public float getDangerPressure() {
            return this.danger;
        }

        public float getCriticalPressure() {
            return this.critical;
        }
    }

    public record Template(int volume, float danger, float critical, ToggleSideConfig.Template config) implements IMachineComponentTemplate<PressureMachineComponent>
    {
        public static final NamedCodec<Template> CODEC = NamedCodec.record(templateInstance -> templateInstance.group((App)NamedCodec.INT.fieldOf("volume").forGetter(Template::volume), (App)NamedCodec.floatRange((float)0.0f, (float)25.0f).fieldOf("danger").forGetter(Template::danger), (App)NamedCodec.floatRange((float)0.0f, (float)25.0f).fieldOf("critical").forGetter(Template::critical), (App)ToggleSideConfig.Template.CODEC.optionalFieldOf("config", (Object)ToggleSideConfig.Template.DEFAULT_ALL_ENABLED).forGetter(Template::config)).apply((Applicative)templateInstance, Template::new), (String)"Pressure machine component");

        public MachineComponentType<PressureMachineComponent> getType() {
            return Registration.PRESSURE_COMPONENT.get();
        }

        public String getId() {
            return "pressure";
        }

        public boolean canAccept(Object ingredient, boolean isInput, IMachineComponentManager manager) {
            return false;
        }

        public PressureMachineComponent build(IMachineComponentManager manager) {
            return new PressureMachineComponent(manager, this.volume, this.danger, this.critical, this.config);
        }
    }
}

