/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinerypnc.common.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.api.component.ComponentIOMode;
import fr.frinn.custommachinery.api.component.IMachineComponentManager;
import fr.frinn.custommachinery.api.component.IMachineComponentTemplate;
import fr.frinn.custommachinery.api.component.ISerializableComponent;
import fr.frinn.custommachinery.api.component.ISideConfigComponent;
import fr.frinn.custommachinery.api.component.ITickableComponent;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.api.network.ISyncable;
import fr.frinn.custommachinery.api.network.ISyncableStuff;
import fr.frinn.custommachinery.common.network.syncable.DoubleSyncable;
import fr.frinn.custommachinery.common.network.syncable.ToggleSideConfigSyncable;
import fr.frinn.custommachinery.impl.component.AbstractMachineComponent;
import fr.frinn.custommachinery.impl.component.config.ToggleSideConfig;
import fr.frinn.custommachinery.impl.component.config.ToggleSideMode;
import fr.frinn.custommachinerypnc.common.Registration;
import java.util.Arrays;
import java.util.function.Consumer;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class HeatMachineComponent
extends AbstractMachineComponent
implements ISideConfigComponent,
ITickableComponent,
ISerializableComponent,
ISyncableStuff {
    private final ToggleSideConfig config;
    private final IHeatExchangerLogic heatExchanger;
    private double prevTemp;

    public HeatMachineComponent(IMachineComponentManager manager, double capacity, double resistance, ToggleSideConfig.Template config) {
        super(manager, ComponentIOMode.BOTH);
        this.config = config.build((ISideConfigComponent)this);
        this.config.setCallback((side, oldMode, newMode) -> {
            this.init();
            this.getManager().getLevel().updateNeighborsAt(this.getManager().getTile().getBlockPos(), this.getManager().getTile().getBlockState().getBlock());
        });
        this.heatExchanger = PneumaticRegistry.getInstance().getHeatRegistry().makeHeatExchangerLogic();
        this.heatExchanger.setThermalCapacity(capacity);
        this.heatExchanger.setThermalResistance(resistance);
        this.upgradeableD(capacity, "capacity", 0.0, Double.MAX_VALUE, arg_0 -> ((IHeatExchangerLogic)this.getHeatExchanger()).setThermalCapacity(arg_0));
        this.upgradeableD(resistance, "resistance", 0.0, Double.MAX_VALUE, arg_0 -> ((IHeatExchangerLogic)this.getHeatExchanger()).setThermalResistance(arg_0));
    }

    public IHeatExchangerLogic getHeatExchanger() {
        return this.heatExchanger;
    }

    public MachineComponentType<HeatMachineComponent> getType() {
        return Registration.HEAT_COMPONENT.get();
    }

    public ToggleSideConfig getConfig() {
        return this.config;
    }

    public String getId() {
        return "PNCHeat";
    }

    public void serverTick() {
        this.heatExchanger.tick();
        if (this.prevTemp != this.heatExchanger.getTemperature()) {
            this.getManager().markDirty();
        }
        this.prevTemp = this.heatExchanger.getTemperature();
    }

    public void init() {
        if (this.getManager().getLevel() == null) {
            return;
        }
        Direction[] validSides = (Direction[])Arrays.stream(Direction.values()).filter(side -> ((ToggleSideMode)this.config.getDirectionMode(side)).isEnabled()).toArray(Direction[]::new);
        this.heatExchanger.initializeAsHull(this.getManager().getLevel(), this.getManager().getTile().getBlockPos(), IHeatExchangerLogic.ALL_BLOCKS, validSides);
    }

    public void serialize(CompoundTag nbt, HolderLookup.Provider registries) {
        nbt.put("pnc_heat", (Tag)this.heatExchanger.serializeNBT());
    }

    public void deserialize(CompoundTag nbt, HolderLookup.Provider registries) {
        if (nbt.contains("pnc_heat", 10)) {
            this.heatExchanger.deserializeNBT(nbt.getCompound("pnc_heat"));
        }
    }

    public void getStuffToSync(Consumer<ISyncable<?, ?>> container) {
        container.accept((ISyncable<?, ?>)DoubleSyncable.create(() -> ((IHeatExchangerLogic)this.heatExchanger).getTemperature(), arg_0 -> ((IHeatExchangerLogic)this.heatExchanger).setTemperature(arg_0)));
        container.accept((ISyncable<?, ?>)ToggleSideConfigSyncable.create(this::getConfig, arg_0 -> ((ToggleSideConfig)this.config).set(arg_0)));
    }

    public record Template(double capacity, double resistance, ToggleSideConfig.Template config) implements IMachineComponentTemplate<HeatMachineComponent>
    {
        public static final NamedCodec<Template> CODEC = NamedCodec.record(templateInstance -> templateInstance.group((App)NamedCodec.doubleRange((double)0.0, (double)Double.MAX_VALUE).optionalFieldOf("capacity", (Object)1.0).forGetter(Template::capacity), (App)NamedCodec.doubleRange((double)0.0, (double)Double.MAX_VALUE).optionalFieldOf("resistance", (Object)1.0).forGetter(Template::resistance), (App)ToggleSideConfig.Template.CODEC.optionalFieldOf("config", (Object)ToggleSideConfig.Template.DEFAULT_ALL_ENABLED).forGetter(Template::config)).apply((Applicative)templateInstance, Template::new), (String)"Heat component template");

        public MachineComponentType<HeatMachineComponent> getType() {
            return Registration.HEAT_COMPONENT.get();
        }

        public String getId() {
            return "PNCHeat";
        }

        public boolean canAccept(Object ingredient, boolean isInput, IMachineComponentManager manager) {
            return false;
        }

        public HeatMachineComponent build(IMachineComponentManager manager) {
            return new HeatMachineComponent(manager, this.capacity, this.resistance, this.config);
        }
    }
}

