/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinerypnc.client.creation.component;

import fr.frinn.custommachinery.api.component.IMachineComponentTemplate;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.client.screen.BaseScreen;
import fr.frinn.custommachinery.client.screen.creation.MachineEditScreen;
import fr.frinn.custommachinery.client.screen.creation.component.ComponentBuilderPopup;
import fr.frinn.custommachinery.client.screen.creation.component.ComponentConfigBuilderWidget;
import fr.frinn.custommachinery.client.screen.creation.component.IMachineComponentBuilder;
import fr.frinn.custommachinery.client.screen.popup.PopupScreen;
import fr.frinn.custommachinery.client.screen.widget.DoubleSlider;
import fr.frinn.custommachinery.impl.component.config.ToggleSideConfig;
import fr.frinn.custommachinerypnc.common.Registration;
import fr.frinn.custommachinerypnc.common.component.HeatMachineComponent;
import java.util.function.Consumer;
import me.desht.pneumaticcraft.common.registry.ModBlocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class HeatComponentBuilder
implements IMachineComponentBuilder<HeatMachineComponent, HeatMachineComponent.Template> {
    public MachineComponentType<HeatMachineComponent> type() {
        return Registration.HEAT_COMPONENT.get();
    }

    public PopupScreen makePopup(MachineEditScreen parent, @Nullable HeatMachineComponent.Template template, Consumer<HeatMachineComponent.Template> onFinish) {
        return new HeatComponentBuilderPopup((BaseScreen)parent, template, onFinish);
    }

    public void render(GuiGraphics graphics, int x, int y, int width, int height, HeatMachineComponent.Template template) {
        graphics.renderFakeItem(ModBlocks.VORTEX_TUBE.toStack(), x, y + height / 2 - 8);
        graphics.drawString(Minecraft.getInstance().font, "type: " + template.getType().getId().getPath(), x + 25, y + 5, 0, false);
    }

    public static class HeatComponentBuilderPopup
    extends ComponentBuilderPopup<HeatMachineComponent.Template> {
        private DoubleSlider capacity;
        private DoubleSlider resistance;
        private ToggleSideConfig.Template config;

        public HeatComponentBuilderPopup(BaseScreen parent, @Nullable HeatMachineComponent.Template template, Consumer<HeatMachineComponent.Template> onFinish) {
            super(parent, (IMachineComponentTemplate)template, onFinish, (Component)Component.translatable((String)"custommachinerypnc.gui.creation.components.pressure.title"));
        }

        public HeatMachineComponent.Template makeTemplate() {
            return new HeatMachineComponent.Template(this.capacity.doubleValue(), this.resistance.doubleValue(), this.config);
        }

        protected void init() {
            super.init();
            this.capacity = (DoubleSlider)this.propertyList.add((Component)Component.translatable((String)"custommachinerypnc.gui.creation.components.heat.capacity"), (AbstractWidget)DoubleSlider.builder().bounds(0.0, 200.0).displayOnlyValue().defaultValue(this.baseTemplate().map(HeatMachineComponent.Template::capacity).orElse(1.0).doubleValue()).create(0, 0, 180, 20, (Component)Component.translatable((String)"custommachinerypnc.gui.creation.components.heat.capacity")));
            this.capacity.setTooltip(Tooltip.create((Component)Component.translatable((String)"custommachinerypnc.gui.creation.components.heat.capacity.tooltip")));
            this.resistance = (DoubleSlider)this.propertyList.add((Component)Component.translatable((String)"custommachinerypnc.gui.creation.components.heat.resistance"), (AbstractWidget)DoubleSlider.builder().bounds(0.0, 200.0).displayOnlyValue().defaultValue(this.baseTemplate().map(HeatMachineComponent.Template::resistance).orElse(1.0).doubleValue()).create(0, 0, 180, 20, (Component)Component.translatable((String)"custommachinerypnc.gui.creation.components.heat.resistance")));
            this.resistance.setTooltip(Tooltip.create((Component)Component.translatable((String)"custommachinerypnc.gui.creation.components.heat.resistance.tooltip")));
            this.baseTemplate().ifPresentOrElse(template -> {
                this.config = template.config();
            }, () -> {
                this.config = ToggleSideConfig.Template.DEFAULT_ALL_ENABLED;
            });
            this.propertyList.add((Component)Component.translatable((String)"custommachinery.gui.config.component"), (AbstractWidget)ComponentConfigBuilderWidget.make((int)0, (int)0, (int)180, (int)20, (Component)Component.translatable((String)"custommachinery.gui.config.component"), (BaseScreen)this.parent, () -> this.config, template -> {
                this.config = template;
            }));
        }
    }
}

