/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.roomopolis.item;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class KeyItemPaletteCache {
    public static final Map<ResourceLocation, Map<Block, Integer>> templatePalettes = new ConcurrentHashMap<ResourceLocation, Map<Block, Integer>>();
    public static final Map<ResourceLocation, List<BlockPosWithState>> renderPalettes = new ConcurrentHashMap<ResourceLocation, List<BlockPosWithState>>();

    public static Map<Block, Integer> getTemplatePalette(ResourceLocation templateId) {
        return templatePalettes.get(templateId);
    }

    public static void setTemplatePalette(ResourceLocation templateId, Map<Block, Integer> palette) {
        templatePalettes.put(templateId, palette);
    }

    public static List<BlockPosWithState> getRenderPalette(ResourceLocation templateId) {
        return renderPalettes.get(templateId);
    }

    public static void setRenderPalette(ResourceLocation templateId, List<BlockPosWithState> palette) {
        renderPalettes.put(templateId, palette);
    }

    public static void cacheTemplate(ResourceLocation templateId, StructureTemplate template) {
        HashMap<Block, Integer> countPalette = new HashMap<Block, Integer>();
        ArrayList<BlockPosWithState> renderPalette = new ArrayList<BlockPosWithState>();
        ((StructureTemplate.Palette)template.palettes.getFirst()).blocks().forEach(blockInfo -> {
            Block block = blockInfo.state().getBlock();
            if (!blockInfo.state().isAir()) {
                countPalette.put(block, countPalette.getOrDefault(block, 0) + 1);
                renderPalette.add(new BlockPosWithState(block, blockInfo.pos()));
            }
        });
        KeyItemPaletteCache.setTemplatePalette(templateId, countPalette);
        KeyItemPaletteCache.setRenderPalette(templateId, renderPalette);
    }

    public record BlockPosWithState(Block block, BlockPos pos) {
    }
}

