/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.roomopolis.integration.kubejs;

import com.benbenlaw.roomopolis.item.KeyItem;
import dev.latvian.mods.kubejs.item.ItemBuilder;
import dev.latvian.mods.kubejs.typings.Info;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

public class KeyItemBuilder
extends ItemBuilder {
    private String templateId;
    private int heightAdjustment;
    private int frontAdjustment = 0;
    private String keyBlock;
    private boolean consumeKey = true;
    private boolean removeDoor = true;
    private boolean sideOnlyPlacement = true;
    private boolean topOnlyPlacement = false;
    private boolean blocksRequired = false;
    private boolean overrideExistingBlocks = false;
    public int doorLeft = 0;
    public int doorRight = 0;
    public int doorUp = 0;
    public int doorDown = 0;
    public int maxHeight = 256;

    public KeyItemBuilder(ResourceLocation i) {
        super(i);
    }

    @Info(value="Resource location of the template eg roomopolis:tiny_room")
    public KeyItemBuilder templateId(String templateId) {
        this.templateId = templateId;
        return this;
    }

    @Info(value="The height adjustment for the template to be placed")
    public KeyItemBuilder heightAdjustment(int heightAdjustment) {
        this.heightAdjustment = heightAdjustment;
        return this;
    }

    @Info(value="The front adjustment for the template to be placed in front or behind the player -2 should be center of the player")
    public KeyItemBuilder frontAdjustment(int frontAdjustment) {
        this.frontAdjustment = frontAdjustment;
        return this;
    }

    @Info(value="The block to use as the key eg minecraft:iron_block or #minecraft:logs for block tags, this is not required")
    public KeyItemBuilder keyBlock(String keyBlock) {
        this.keyBlock = keyBlock.isEmpty() ? null : keyBlock;
        return this;
    }

    @Info(value="Is the key consumed when used, default true")
    public KeyItemBuilder consumeKey(boolean consumeKey) {
        this.consumeKey = consumeKey;
        return this;
    }

    @Info(value="If using the key removes a 2 high door, default true")
    public KeyItemBuilder removeDoor(boolean removeDoor) {
        this.removeDoor = removeDoor;
        return this;
    }

    @Info(value="If the template can only be placed on the side of a block, default true")
    public KeyItemBuilder sideOnlyPlacement(boolean sideOnlyPlacement) {
        this.sideOnlyPlacement = sideOnlyPlacement;
        return this;
    }

    @Info(value="If the template can only be placed on top of a block, default false")
    public KeyItemBuilder topOnlyPlacement(boolean topOnlyPlacement) {
        this.topOnlyPlacement = topOnlyPlacement;
        return this;
    }

    @Info(value="If the template requires blocks to be placed, default false")
    public KeyItemBuilder blocksRequired(boolean blocksRequired) {
        this.blocksRequired = blocksRequired;
        return this;
    }

    @Info(value="If false normal checks for placement are done if true the template will be placed no matter the blocks in the world, default false")
    public KeyItemBuilder overrideExistingBlocks(boolean overrideExistingBlocks) {
        this.overrideExistingBlocks = overrideExistingBlocks;
        return this;
    }

    @Info(value="How many block to the left of the key block an opening should be created, default 0")
    public KeyItemBuilder doorLeft(int doorLeft) {
        this.doorLeft = doorLeft;
        return this;
    }

    @Info(value="How many block to the right of the key block an opening should be created, default 0")
    public KeyItemBuilder doorRight(int doorRight) {
        this.doorRight = doorRight;
        return this;
    }

    @Info(value="How many block above the key block an opening should be created, default 0")
    public KeyItemBuilder doorUp(int doorUp) {
        this.doorUp = doorUp;
        return this;
    }

    @Info(value="How many block below the key block an opening should be created, default 0")
    public KeyItemBuilder doorDown(int doorDown) {
        this.doorDown = doorDown;
        return this;
    }

    @Info(value="The maximum height the template can be placed, default 256")
    public KeyItemBuilder maxHeight(int maxHeight) {
        this.maxHeight = maxHeight;
        return this;
    }

    public Item createObject() {
        return new KeyItem(this.createItemProperties(), this.templateId, this.heightAdjustment, this.frontAdjustment, this.keyBlock, this.consumeKey, this.removeDoor, this.sideOnlyPlacement, this.topOnlyPlacement, this.blocksRequired, this.overrideExistingBlocks, this.doorLeft, this.doorRight, this.doorUp, this.doorDown, this.maxHeight);
    }
}

