/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.roomopolis.integration.jei;

import com.benbenlaw.roomopolis.block.RoomopolisBlocks;
import com.benbenlaw.roomopolis.integration.jei.RoomRecipe;
import com.benbenlaw.roomopolis.item.FakeStructureTemplateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.gui.widgets.IScrollGridWidgetFactory;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.jetbrains.annotations.Nullable;

public class RoomCategory
implements IRecipeCategory<RoomRecipe> {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"roomopolis", (String)"room_category");
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"roomopolis", (String)"textures/gui/jei_room_category.png");
    static final RecipeType<RoomRecipe> RECIPE_TYPE = RecipeType.create((String)"roomopolis", (String)"room_category", RoomRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;
    private final IScrollGridWidgetFactory<?> scrollGridWidgetFactory;

    public RoomCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 140, 100);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)((Block)RoomopolisBlocks.ROOM_BLOCK.get()).asItem()));
        this.scrollGridWidgetFactory = helper.createScrollGridFactory(1, 5);
        this.scrollGridWidgetFactory.setPosition(103, 6);
    }

    public RecipeType<RoomRecipe> getRecipeType() {
        return RECIPE_TYPE;
    }

    public Component getTitle() {
        return Component.translatable((String)"category.roomopolis.room_category");
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    @Nullable
    public IDrawable getBackground() {
        return this.background;
    }

    @Nullable
    public ResourceLocation getRegistryName(RoomRecipe recipe) {
        return recipe.templateId();
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RoomRecipe recipe, IFocusGroup iFocusGroup) {
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 1).addItemStack(recipe.keyItem());
        if (recipe.keyBlock().isPresent()) {
            builder.addSlot(RecipeIngredientRole.CATALYST, 37, 1).addItemStack(recipe.keyBlock().get().asItem().getDefaultInstance());
        }
        if (recipe.keyBlockTag().isPresent()) {
            TagKey<Block> tag = recipe.keyBlockTag().get();
            ArrayList tagStack = new ArrayList();
            BuiltInRegistries.BLOCK.getTagOrEmpty(tag).forEach(block -> tagStack.add(new ItemStack((ItemLike)((Block)block.value()).asItem())));
            builder.addSlot(RecipeIngredientRole.CATALYST, 37, 1).addItemStacks(tagStack);
        }
        if (recipe.requiresBlocks()) {
            Map<ItemStack, Integer> requiredBlocks = recipe.requiredItems();
            for (Map.Entry<ItemStack, Integer> entry : requiredBlocks.entrySet()) {
                ItemStack stack = entry.getKey().copy();
                int count = entry.getValue();
                stack.setCount(count);
                builder.addSlotToWidget(RecipeIngredientRole.INPUT, this.scrollGridWidgetFactory).addItemStack(stack);
            }
        }
    }

    public void getTooltip(ITooltipBuilder tooltip, RoomRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        double left = 1.0;
        double top = 20.0;
        double right = 115.0;
        double bottom = 100.0;
        if (mouseX >= left && mouseX <= right && mouseY >= top && mouseY <= bottom) {
            Minecraft mc = Minecraft.getInstance();
            ClientLevel level = mc.level;
            Optional<StructureTemplate> optionalTemplate = FakeStructureTemplateManager.INSTANCE.get(recipe.templateId());
            if (optionalTemplate.isPresent()) {
                StructureTemplate template = optionalTemplate.get();
                int sizeX = template.getSize().getX();
                int sizeY = template.getSize().getY();
                int sizeZ = template.getSize().getZ();
                tooltip.add((FormattedText)Component.translatable((String)"roomopolis.jei.tooltip.rotate", (Object[])new Object[]{sizeX, sizeY, sizeZ}));
            }
        }
    }

    public void draw(RoomRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        Minecraft mc = Minecraft.getInstance();
        ClientLevel level = mc.level;
        assert (level != null);
        assert (mc.getSingleplayerServer() != null);
        Optional<StructureTemplate> optionalTemplate = FakeStructureTemplateManager.INSTANCE.get(recipe.templateId());
        if (optionalTemplate.isEmpty()) {
            guiGraphics.drawString(mc.font, (Component)Component.literal((String)("BROKEN" + recipe.templateId().toString())), 5, 5, 0x404040, false);
        } else {
            StructureTemplate template = optionalTemplate.get();
            PoseStack poseStack = guiGraphics.pose();
            RenderSystem.enableDepthTest();
            Lighting.setupFor3DItems();
            poseStack.pushPose();
            poseStack.translate(50.0f, 60.0f, 50.0f);
            float scale = 70.0f / (float)Math.max(template.getSize().getX(), Math.max(template.getSize().getY(), template.getSize().getZ()));
            poseStack.scale(scale, -scale, scale);
            float angle = (float)(System.currentTimeMillis() % 10000L) / 10000.0f * 360.0f;
            poseStack.mulPose(Axis.YP.rotationDegrees(angle));
            this.renderStructure(template, poseStack);
            poseStack.popPose();
            Lighting.setupForFlatItems();
            RenderSystem.disableDepthTest();
        }
    }

    private void renderStructure(StructureTemplate template, PoseStack poseStack) {
        Minecraft mc = Minecraft.getInstance();
        BlockRenderDispatcher dispatcher = mc.getBlockRenderer();
        MultiBufferSource.BufferSource buffer = mc.renderBuffers().bufferSource();
        double centerX = (double)template.getSize().getX() / 2.0;
        double centerY = (double)template.getSize().getY() / 2.0;
        double centerZ = (double)template.getSize().getZ() / 2.0;
        HashSet placedDoubleBlocks = new HashSet();
        for (StructureTemplate.StructureBlockInfo blockInfo : ((StructureTemplate.Palette)template.palettes.getFirst()).blocks()) {
            BlockState state = blockInfo.state();
            Block block = state.getBlock();
            BlockPos pos = blockInfo.pos();
            if (state.isAir()) continue;
            poseStack.pushPose();
            poseStack.translate((double)pos.getX() - centerX, (double)pos.getY() - centerY, (double)pos.getZ() - centerZ);
            dispatcher.renderSingleBlock(state, poseStack, (MultiBufferSource)buffer, 0xF000F0, OverlayTexture.NO_OVERLAY, ModelData.EMPTY, RenderType.TRANSLUCENT);
            poseStack.popPose();
        }
        buffer.endBatch();
    }
}

