/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.roomopolis.integration.jei;

import com.benbenlaw.roomopolis.block.RoomopolisBlocks;
import com.benbenlaw.roomopolis.integration.jei.RoomCategory;
import com.benbenlaw.roomopolis.integration.jei.RoomRecipe;
import com.benbenlaw.roomopolis.item.KeyItem;
import com.benbenlaw.roomopolis.item.KeyItemPaletteCache;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

@JeiPlugin
public class JEIRoomopolisPlugin
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return ResourceLocation.fromNamespaceAndPath((String)"roomopolis", (String)"jei_plugin");
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)RoomopolisBlocks.ROOM_BLOCK.get()), new RecipeType[]{RoomCategory.RECIPE_TYPE});
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper guiHelper = registration.getJeiHelpers().getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new RoomCategory(guiHelper)});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        ArrayList<RoomRecipe> recipes = new ArrayList<RoomRecipe>();
        for (Item item : BuiltInRegistries.ITEM) {
            if (!(item instanceof KeyItem)) continue;
            KeyItem keyItem = (KeyItem)item;
            Map<Block, Integer> palette = KeyItemPaletteCache.getTemplatePalette(keyItem.templateId);
            if (palette == null) continue;
            HashMap<ItemStack, Integer> requiredItems = new HashMap<ItemStack, Integer>();
            for (Map.Entry<Block, Integer> entry : palette.entrySet()) {
                ItemStack stack = new ItemStack((ItemLike)entry.getKey().asItem());
                requiredItems.put(stack, entry.getValue());
            }
            recipes.add(new RoomRecipe(keyItem.templateId, keyItem.asItem().getDefaultInstance(), requiredItems, keyItem.blocksRequired, keyItem.keyBlock, keyItem.keyBlockTag));
        }
        registration.addRecipes(RoomCategory.RECIPE_TYPE, recipes);
    }
}

