/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.roomopolis.client;

import com.benbenlaw.roomopolis.item.FakeStructureTemplateManager;
import com.benbenlaw.roomopolis.item.KeyItem;
import com.benbenlaw.roomopolis.item.KeyItemSizeCache;
import com.benbenlaw.roomopolis.util.DirectionUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Optional;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;

@OnlyIn(value=Dist.CLIENT)
public class KeyPreviewRenderer {
    private static ItemStack lastStack = ItemStack.EMPTY;
    private static KeyItem lastKeyItem = null;
    private static BlockPos lastValidPos = null;
    private static Direction lastValidFace = null;

    public static void onRenderLevel(RenderLevelStageEvent event) {
        Vec3i templateSize;
        BlockHitResult blockHit;
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_BLOCK_ENTITIES) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        ClientLevel level = mc.level;
        if (player == null || level == null) {
            return;
        }
        ItemStack currentStack = player.getMainHandItem();
        if (!ItemStack.isSameItem((ItemStack)currentStack, (ItemStack)lastStack)) {
            KeyItem keyItem;
            lastStack = currentStack;
            Item item = currentStack.getItem();
            lastKeyItem = item instanceof KeyItem ? (keyItem = (KeyItem)item) : null;
            lastValidPos = null;
            lastValidFace = null;
        }
        if (lastKeyItem == null) {
            return;
        }
        HitResult hit = mc.hitResult;
        BlockPos clickedPos = null;
        Direction face = null;
        if (hit instanceof BlockHitResult && (blockHit = (BlockHitResult)hit).getType() == HitResult.Type.BLOCK && KeyPreviewRenderer.canPreviewPlace(lastKeyItem, (Player)player, clickedPos = blockHit.getBlockPos(), face = blockHit.getDirection())) {
            lastValidPos = clickedPos;
            lastValidFace = face;
        }
        if (lastValidPos == null || lastValidFace == null) {
            return;
        }
        Rotation rotation = DirectionUtil.getRotationFromDirection(lastValidFace);
        Direction facing = lastValidFace.getOpposite();
        BlockPos placePosition = lastValidPos;
        if (lastValidFace == Direction.UP) {
            placePosition = lastValidPos.above(3);
            rotation = DirectionUtil.getRotationFromDirection(player.getDirection().getOpposite());
        }
        if ((templateSize = KeyItemSizeCache.getTemplateSize(KeyPreviewRenderer.lastKeyItem.templateId)) == null) {
            return;
        }
        Optional<StructureTemplate> optionalTemplate = FakeStructureTemplateManager.INSTANCE.get(KeyPreviewRenderer.lastKeyItem.templateId);
        if (optionalTemplate.isEmpty()) {
            return;
        }
        StructureTemplate template = optionalTemplate.get();
        StructurePlaceSettings settings = new StructurePlaceSettings().setRotation(rotation).setMirror(Mirror.NONE);
        BlockPos centerOffset = new BlockPos(-templateSize.getX() / 2, -templateSize.getY() / 2, -templateSize.getZ() / 2);
        BlockPos adjustedOffset = StructureTemplate.calculateRelativePosition((StructurePlaceSettings)settings, (BlockPos)centerOffset);
        int forwardShift = Math.max(templateSize.getX() / 2, 1) + 1 + KeyPreviewRenderer.lastKeyItem.frontAdjustment;
        BlockPos forwardOffset = placePosition.relative(facing, forwardShift);
        BlockPos placementPos = forwardOffset.offset((Vec3i)adjustedOffset).above(KeyPreviewRenderer.lastKeyItem.heightAdjustment);
        PoseStack poseStack = event.getPoseStack();
        Camera camera = mc.gameRenderer.getMainCamera();
        Vec3 camPos = camera.getPosition();
        poseStack.pushPose();
        poseStack.translate((double)placementPos.getX() - camPos.x, (double)placementPos.getY() - camPos.y, (double)placementPos.getZ() - camPos.z);
        StructureTemplate.Palette palette = (StructureTemplate.Palette)template.palettes.getFirst();
        BlockRenderDispatcher blockRenderer = mc.getBlockRenderer();
        MultiBufferSource.BufferSource translucentBuffer = mc.renderBuffers().bufferSource();
        MultiBufferSource.BufferSource lineBufferSource = mc.renderBuffers().bufferSource();
        VertexConsumer lineBuffer = lineBufferSource.getBuffer((RenderType)RenderType.LINES);
        BlockPos min = null;
        BlockPos max = null;
        for (StructureTemplate.StructureBlockInfo info : palette.blocks()) {
            BlockPos rel = info.pos();
            BlockPos rotatedPos = StructureTemplate.calculateRelativePosition((StructurePlaceSettings)settings, (BlockPos)rel);
            BlockState state = info.state();
            if (state.isAir()) continue;
            BlockState rotatedState = state.rotate(settings.getRotation());
            poseStack.pushPose();
            poseStack.translate((float)rotatedPos.getX(), (float)rotatedPos.getY(), (float)rotatedPos.getZ());
            blockRenderer.renderSingleBlock(rotatedState, poseStack, (MultiBufferSource)translucentBuffer, 0xF000F0, OverlayTexture.NO_OVERLAY);
            poseStack.popPose();
            VoxelShape shape = rotatedState.getShape((BlockGetter)level, placementPos.offset((Vec3i)rotatedPos));
            if (shape.isEmpty()) continue;
            AABB shapeBounds = shape.bounds();
            BlockPos blockMin = new BlockPos(rotatedPos.getX() + (int)Math.floor(shapeBounds.minX), rotatedPos.getY() + (int)Math.floor(shapeBounds.minY), rotatedPos.getZ() + (int)Math.floor(shapeBounds.minZ));
            BlockPos blockMax = new BlockPos(rotatedPos.getX() + (int)Math.ceil(shapeBounds.maxX), rotatedPos.getY() + (int)Math.ceil(shapeBounds.maxY), rotatedPos.getZ() + (int)Math.ceil(shapeBounds.maxZ));
            min = min == null ? blockMin : new BlockPos(Math.min(min.getX(), blockMin.getX()), Math.min(min.getY(), blockMin.getY()), Math.min(min.getZ(), blockMin.getZ()));
            if (max == null) {
                max = blockMax;
                continue;
            }
            max = new BlockPos(Math.max(max.getX(), blockMax.getX()), Math.max(max.getY(), blockMax.getY()), Math.max(max.getZ(), blockMax.getZ()));
        }
        if (min != null && max != null) {
            Vec3 minVec = new Vec3((double)min.getX(), (double)min.getY(), (double)min.getZ());
            Vec3 maxVec = new Vec3((double)max.getX(), (double)max.getY(), (double)max.getZ());
            AABB structureBox = new AABB(minVec, maxVec);
            LevelRenderer.renderLineBox((PoseStack)poseStack, (VertexConsumer)lineBuffer, (AABB)structureBox, (float)0.1f, (float)1.0f, (float)0.1f, (float)1.0f);
        }
        poseStack.popPose();
        translucentBuffer.endBatch();
        lineBufferSource.endBatch();
    }

    @OnlyIn(value=Dist.CLIENT)
    private static boolean canPreviewPlace(KeyItem key, Player player, BlockPos lookPos, Direction face) {
        if (key.keyBlock.isPresent() && !player.level().getBlockState(lookPos).is(key.keyBlock.get())) {
            return false;
        }
        if (key.keyBlockTag.isPresent() && !player.level().getBlockState(lookPos).is(key.keyBlockTag.get())) {
            return false;
        }
        if (key.topOnlyPlacement && face != Direction.UP) {
            return false;
        }
        return !key.sideOnlyPlacement || !face.getAxis().isVertical();
    }
}

