/*
 * Decompiled with CFR 0.152.
 */
package com.leaky;

import com.cupboard.config.CupboardConfig;
import com.cupboard.config.ICommonConfig;
import com.leaky.INearbyItemAwareEntity;
import com.leaky.config.CommonConfiguration;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="leaky")
public class Leaky {
    public static final String MODID = "leaky";
    public static final Logger LOGGER = LogManager.getLogger();
    public static CupboardConfig<CommonConfiguration> config = new CupboardConfig("leaky", (ICommonConfig)new CommonConfiguration());
    public static final int CONTAIN_RADIUS_SQR = 16;
    public static final int REPORT_RADIUS_SQR = 100;
    public static Random rand = new Random();
    private static Object2LongOpenHashMap<BlockPos> reportedLocations = new Object2LongOpenHashMap();

    public Leaky(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::setup);
    }

    private void setup(FMLCommonSetupEvent event) {
        config.load();
        LOGGER.info("leaky mod initialized");
    }

    public static void detectedItemLeak(ItemEntity entity, List<ItemEntity> items, int range) {
        int size = items.size();
        for (ItemEntity item : items) {
            if (!(item instanceof INearbyItemAwareEntity)) continue;
            INearbyItemAwareEntity nearbyItemAware = (INearbyItemAwareEntity)item;
            nearbyItemAware.setNearbyItems(size);
        }
        if (range > 2 && size < ((CommonConfiguration)Leaky.config.getCommonConfig()).autoremovethreshold * 3) {
            size /= 2;
        }
        if (size < ((CommonConfiguration)Leaky.config.getCommonConfig()).reportThreshold) {
            return;
        }
        boolean contained = false;
        if (size < ((CommonConfiguration)Leaky.config.getCommonConfig()).autoremovethreshold * 3) {
            long now = entity.level().getGameTime();
            for (Map.Entry entry : reportedLocations.entrySet()) {
                double dist = ((BlockPos)entry.getKey()).distSqr((Vec3i)entity.blockPosition());
                if (dist < 16.0) {
                    contained = true;
                }
                if (!(dist < 100.0) || now - (Long)entry.getValue() >= (long)(((CommonConfiguration)Leaky.config.getCommonConfig()).reportInterval * 20)) continue;
                return;
            }
        }
        reportedLocations.put((Object)entity.blockPosition(), entity.level().getGameTime());
        MutableComponent component = Component.translatable((String)"leaky.detect", (Object[])new Object[]{items.size(), Component.translatable((String)entity.level().dimension().location().toLanguageKey())}).append((Component)Component.literal((String)("[" + entity.blockPosition().toShortString() + "]")).withStyle(ChatFormatting.YELLOW).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tp " + entity.getBlockX() + " " + entity.getBlockY() + " " + entity.getBlockZ()))));
        if (size > ((CommonConfiguration)Leaky.config.getCommonConfig()).autoremovethreshold && (contained || size >= ((CommonConfiguration)Leaky.config.getCommonConfig()).autoremovethreshold * 3)) {
            component.append((Component)Component.translatable((String)"leaky.removedItems"));
            items.forEach(Entity::discard);
        }
        if (((CommonConfiguration)Leaky.config.getCommonConfig()).chatnotification.equalsIgnoreCase("PLAYER")) {
            double dist = Double.MAX_VALUE;
            closest = null;
            for (Player player : entity.level().players()) {
                if (!(player.position().distanceTo(entity.position()) < dist)) continue;
                dist = player.position().distanceTo(entity.position());
                closest = player;
            }
            if (closest != null) {
                closest.sendSystemMessage((Component)component);
            }
        } else if (((CommonConfiguration)Leaky.config.getCommonConfig()).chatnotification.equalsIgnoreCase("EVERYONE")) {
            for (Player player : entity.level().getServer().getPlayerList().getPlayers()) {
                player.sendSystemMessage((Component)component);
            }
        } else if (((CommonConfiguration)Leaky.config.getCommonConfig()).chatnotification.equalsIgnoreCase("OP")) {
            double dist = Double.MAX_VALUE;
            closest = null;
            for (Player player : entity.level().players()) {
                if (!player.level().getServer().getPlayerList().isOp(player.getGameProfile()) || !(player.position().distanceTo(entity.position()) < dist)) continue;
                dist = player.position().distanceTo(entity.position());
                closest = player;
            }
            if (closest != null) {
                closest.sendSystemMessage((Component)component);
            }
        } else {
            component.append((Component)Component.literal((String)(" Chatnotification mode:NONE(" + ((CommonConfiguration)Leaky.config.getCommonConfig()).chatnotification + ")")));
        }
        LOGGER.warn(component.getString());
    }
}

