/*
 * Decompiled with CFR 0.152.
 */
package com.falaut.kubejsnaturesaura.utils;

import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.container.IAuraContainer;
import de.ellpeck.naturesaura.api.aura.type.IAuraType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class AuraItemUtils {
    @Nullable
    private IAuraContainer getAuraContainer(ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        return (IAuraContainer)itemStack.getCapability(NaturesAuraAPI.AURA_CONTAINER_ITEM_CAPABILITY, null);
    }

    public Number getStoredAura(ItemStack itemStack) {
        IAuraContainer cap = this.getAuraContainer(itemStack);
        return cap != null ? Integer.valueOf(cap.getStoredAura()) : null;
    }

    public Number getMaxAura(ItemStack itemStack) {
        IAuraContainer cap = this.getAuraContainer(itemStack);
        return cap != null ? Integer.valueOf(cap.getMaxAura()) : null;
    }

    public Number getAuraColor(ItemStack itemStack) {
        IAuraContainer cap = this.getAuraContainer(itemStack);
        return cap != null ? Integer.valueOf(cap.getAuraColor()) : null;
    }

    public Boolean isAcceptableType(ItemStack itemStack, String auraType) {
        IAuraType auraTypeObj;
        IAuraContainer cap = this.getAuraContainer(itemStack);
        if (cap != null && (auraTypeObj = (IAuraType)NaturesAuraAPI.AURA_TYPES.get(ResourceLocation.parse((String)auraType))) != null) {
            return cap.isAcceptableType(auraTypeObj);
        }
        return null;
    }

    public void storeAura(ItemStack itemStack, Integer aura, Boolean simulate) {
        IAuraContainer cap = this.getAuraContainer(itemStack);
        if (cap != null) {
            cap.storeAura(aura.intValue(), simulate.booleanValue());
        }
    }

    public void drainAura(ItemStack itemStack, Integer aura, Boolean simulate) {
        IAuraContainer cap = this.getAuraContainer(itemStack);
        if (cap != null) {
            cap.drainAura(aura.intValue(), simulate.booleanValue());
        }
    }
}

