/*
 * Decompiled with CFR 0.152.
 */
package com.falaut.kubejsnaturesaura.utils;

import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.container.IAuraContainer;
import de.ellpeck.naturesaura.api.aura.type.IAuraType;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class AuraBlockUtils {
    private IAuraContainer getAuraContainer(BlockEntity blockEntity) {
        if (blockEntity == null) {
            return null;
        }
        Level level = blockEntity.getLevel();
        BlockPos pos = blockEntity.getBlockPos();
        BlockEntity tile = level.getBlockEntity(pos);
        return (IAuraContainer)level.getCapability(NaturesAuraAPI.AURA_CONTAINER_BLOCK_CAPABILITY, tile.getBlockPos(), tile.getBlockState(), tile, null);
    }

    public Number getStoredAura(BlockEntity blockEntity) {
        IAuraContainer cap = this.getAuraContainer(blockEntity);
        return cap != null ? Integer.valueOf(cap.getStoredAura()) : null;
    }

    public Number getMaxAura(BlockEntity blockEntity) {
        IAuraContainer cap = this.getAuraContainer(blockEntity);
        return cap != null ? Integer.valueOf(cap.getMaxAura()) : null;
    }

    public Number getAuraColor(BlockEntity blockEntity) {
        IAuraContainer cap = this.getAuraContainer(blockEntity);
        return cap != null ? Integer.valueOf(cap.getAuraColor()) : null;
    }

    public Boolean isAcceptableType(BlockEntity blockEntity, String auraType) {
        IAuraType auraTypeObj;
        IAuraContainer cap = this.getAuraContainer(blockEntity);
        if (cap != null && (auraTypeObj = (IAuraType)NaturesAuraAPI.AURA_TYPES.get(ResourceLocation.parse((String)auraType))) != null) {
            return cap.isAcceptableType(auraTypeObj);
        }
        return null;
    }

    public void storeAura(BlockEntity blockEntity, Integer aura, Boolean simulate) {
        IAuraContainer cap = this.getAuraContainer(blockEntity);
        if (cap != null) {
            cap.storeAura(aura.intValue(), simulate.booleanValue());
        }
    }

    public void drainAura(BlockEntity blockEntity, Integer aura, Boolean simulate) {
        IAuraContainer cap = this.getAuraContainer(blockEntity);
        if (cap != null) {
            cap.drainAura(aura.intValue(), simulate.booleanValue());
        }
    }
}

