/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.inventory.container.data;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import java.util.Objects;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.Tag;

public abstract class AbstractDataStore<T> {
    protected T value;

    public AbstractDataStore(T defaultValue) {
        this.value = defaultValue;
    }

    public T get() {
        return this.value;
    }

    public void set(T value) {
        this.value = value;
        this.markDirty();
    }

    public void markDirty() {
    }

    public abstract void toBytes(MCDataOutput var1);

    public abstract void fromBytes(MCDataInput var1);

    public abstract Tag toTag(HolderLookup.Provider var1);

    public abstract void fromTag(HolderLookup.Provider var1, Tag var2);

    public boolean isSameValue(T newValue) {
        return Objects.equals(this.value, newValue);
    }
}

