/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.modules.scanner.items;

import com.mojang.serialization.Codec;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import javax.annotation.Nonnull;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.ModuleTools;
import mcjty.lib.varia.Tools;
import mcjty.rftoolsbase.api.screens.IClientScreenModule;
import mcjty.rftoolsbase.api.screens.IModuleGuiBuilder;
import mcjty.rftoolsbase.api.screens.IScreenModule;
import mcjty.rftoolsbase.api.storage.IStorageScanner;
import mcjty.rftoolsbase.tools.GenericModuleItem;
import mcjty.rftoolsstorage.RFToolsStorage;
import mcjty.rftoolsstorage.modules.scanner.StorageScannerConfiguration;
import mcjty.rftoolsstorage.modules.scanner.StorageScannerModule;
import mcjty.rftoolsstorage.modules.scanner.items.DumpClientScreenModule;
import mcjty.rftoolsstorage.modules.scanner.items.DumpScreenModule;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class DumpModuleItem
extends GenericModuleItem {
    public DumpModuleItem() {
        super(RFToolsStorage.setup.defaultProperties().durability(1));
    }

    protected int getUses(ItemStack stack) {
        return (Integer)StorageScannerConfiguration.DUMP_RFPERTICK.get();
    }

    protected boolean hasGoldMessage(ItemStack stack) {
        return !ModuleTools.hasModuleTarget((ItemStack)stack);
    }

    protected String getInfoString(ItemStack stack) {
        return ModuleTools.getTargetString((ItemStack)stack);
    }

    @Nullable
    public Codec<? extends IScreenModule<?, ?>> codec() {
        return DumpScreenModule.CODEC;
    }

    @Nullable
    public StreamCodec<RegistryFriendlyByteBuf, ? extends IScreenModule<?, ?>> streamCodec() {
        return DumpScreenModule.STREAM_CODEC;
    }

    @Nullable
    public DataComponentType<? extends IScreenModule<?, ?>> componentType() {
        return (DataComponentType)StorageScannerModule.MODULE_DUMP_DATA.get();
    }

    public IScreenModule<?, ?> createServerScreenModule() {
        return DumpScreenModule.DEFAULT;
    }

    public IClientScreenModule<?> createClientScreenModule() {
        return new DumpClientScreenModule();
    }

    public String getModuleName() {
        return "Dump";
    }

    public static DumpScreenModule data(ItemStack stack) {
        DumpScreenModule data = (DumpScreenModule)stack.get(StorageScannerModule.MODULE_DUMP_DATA);
        if (data == null) {
            data = DumpScreenModule.DEFAULT;
        }
        return data;
    }

    public static void data(ItemStack stack, Function<DumpScreenModule, DumpScreenModule> setter) {
        DumpScreenModule data = DumpModuleItem.data(stack);
        data = setter.apply(data);
        stack.set(StorageScannerModule.MODULE_DUMP_DATA, (Object)data);
    }

    public void createGui(IModuleGuiBuilder guiBuilder) {
        AtomicInteger index = new AtomicInteger(0);
        for (int y = 0; y < 4; ++y) {
            for (int x = 0; x < 7; ++x) {
                guiBuilder.ghostStack((module, stack) -> DumpModuleItem.data(module, d -> d.withStack(index.get(), (ItemStack)stack)), module -> DumpModuleItem.data(module).stacks().get(index.get()));
                index.addAndGet(1);
            }
            guiBuilder.nl();
        }
        guiBuilder.label("Label:").text((module, text) -> DumpModuleItem.data(module, d -> d.withLine((String)text)), module -> DumpModuleItem.data(module).line(), new String[]{"Label text"}).color((module, color) -> DumpModuleItem.data(module, d -> d.withColor((int)color)), module -> DumpModuleItem.data(module).color(), new String[]{"Label color"}).nl().toggle((module, tag) -> DumpModuleItem.data(module, d -> d.withMatchingTag((boolean)tag)), module -> DumpModuleItem.data(module).matchingTag(), "Matching Tag", new String[]{"If enabled use common tags", "to match items"});
    }

    @Nonnull
    public InteractionResult useOn(UseOnContext context) {
        BlockPos pos;
        ItemStack stack = context.getItemInHand();
        Level world = context.getLevel();
        BlockEntity te = world.getBlockEntity(pos = context.getClickedPos());
        if (te instanceof IStorageScanner) {
            BlockState state = world.getBlockState(pos);
            String name = "<invalid>";
            if (!state.isAir()) {
                name = Tools.getReadableName((Level)world, (BlockPos)pos);
            }
            ModuleTools.setPositionInModule((ItemStack)stack, (ResourceKey)world.dimension(), (BlockPos)pos, (String)name);
            if (world.isClientSide) {
                Logging.message((Player)context.getPlayer(), (String)("Storage module is set to block '" + name + "'"));
            }
        } else {
            ModuleTools.clearPositionInModule((ItemStack)stack);
            if (world.isClientSide) {
                Logging.message((Player)context.getPlayer(), (String)"Storage module is cleared");
            }
        }
        return InteractionResult.SUCCESS;
    }
}

