/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.opolisutilities.screen.custom;

import com.benbenlaw.opolisutilities.networking.payload.SmartCraftingRecipePayload;
import com.benbenlaw.opolisutilities.screen.ModMenuTypes;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

@Deprecated(since="4.12.2", forRemoval=true)
public class SmartCraftingMenu
extends AbstractContainerMenu {
    protected Level level;
    protected ContainerData data;
    protected Player player;
    protected BlockPos blockPos;
    private final NonNullList<ItemStack> lastInventorySnapshot;

    public SmartCraftingMenu(int containerID, Inventory inventory, FriendlyByteBuf extraData) {
        this(containerID, inventory, extraData.readBlockPos(), (ContainerData)new SimpleContainerData(2));
    }

    public SmartCraftingMenu(int containerID, Inventory inventory, BlockPos blockPos, ContainerData data) {
        super((MenuType)ModMenuTypes.SMART_CRAFTING_MENU.get(), containerID);
        this.player = inventory.player;
        this.blockPos = blockPos;
        this.level = inventory.player.level();
        this.data = data;
        this.lastInventorySnapshot = NonNullList.withSize((int)this.player.getInventory().items.size(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < this.player.getInventory().items.size(); ++i) {
            this.lastInventorySnapshot.set(i, (Object)((ItemStack)this.player.getInventory().items.get(i)).copy());
        }
        if (!this.level.isClientSide) {
            this.updateValidRecipes();
        }
        SmartCraftingMenu.checkContainerSize((Container)inventory, (int)2);
        this.addPlayerInventory(inventory);
        this.addPlayerHotbar(inventory);
        this.addDataSlots(data);
    }

    public void updateValidRecipes() {
        if (this.level.isClientSide) {
            return;
        }
        List<RecipeHolder<CraftingRecipe>> recipes = this.getValidRecipes();
        List<ResourceLocation> recipeIds = recipes.stream().map(RecipeHolder::id).toList();
        this.sendRecipesToClient(recipeIds);
    }

    private void sendRecipesToClient(List<ResourceLocation> recipeIds) {
        SmartCraftingRecipePayload packet = new SmartCraftingRecipePayload(recipeIds);
        PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)this.player), (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public List<RecipeHolder<CraftingRecipe>> getValidRecipes() {
        if (this.level.isClientSide) {
            return Collections.emptyList();
        }
        RecipeManager rm = this.level.getRecipeManager();
        List allRecipes = rm.getAllRecipesFor(RecipeType.CRAFTING);
        Inventory inv = this.player.getInventory();
        return allRecipes.stream().filter(holder -> this.canCraftFromInventory((CraftingRecipe)holder.value(), inv)).toList();
    }

    private boolean canCraftFromInventory(CraftingRecipe recipe, Inventory inv) {
        CraftingInput input = this.buildCraftingInputForRecipe(recipe, inv);
        return recipe.matches((RecipeInput)input, this.level);
    }

    private CraftingInput buildCraftingInputForRecipe(CraftingRecipe recipe, Inventory inv) {
        NonNullList grid = NonNullList.withSize((int)9, (Object)ItemStack.EMPTY);
        NonNullList ingredients = recipe.getIngredients();
        int[] usedSlots = new int[inv.getContainerSize()];
        if (recipe instanceof ShapedRecipe) {
            ShapedRecipe shaped = (ShapedRecipe)recipe;
            int width = shaped.getWidth();
            int height = shaped.getHeight();
            for (int row = 0; row < height; ++row) {
                block1: for (int col = 0; col < width; ++col) {
                    Ingredient ing;
                    int recipeIndex = row * width + col;
                    int gridIndex = row * 3 + col;
                    if (recipeIndex >= ingredients.size() || (ing = (Ingredient)ingredients.get(recipeIndex)).isEmpty()) continue;
                    for (int i = 0; i < inv.getContainerSize(); ++i) {
                        ItemStack stack = inv.getItem(i);
                        if (stack.isEmpty() || usedSlots[i] >= stack.getCount() || !ing.test(stack)) continue;
                        ItemStack copy = stack.copy();
                        copy.setCount(1);
                        grid.set(gridIndex, (Object)copy);
                        int n = i;
                        usedSlots[n] = usedSlots[n] + 1;
                        continue block1;
                    }
                }
            }
        } else {
            int placed = 0;
            block3: for (Ingredient ing : ingredients) {
                if (ing.isEmpty()) continue;
                for (int i = 0; i < inv.getContainerSize(); ++i) {
                    ItemStack stack = inv.getItem(i);
                    if (stack.isEmpty() || usedSlots[i] >= stack.getCount() || !ing.test(stack)) continue;
                    ItemStack copy = stack.copy();
                    copy.setCount(1);
                    grid.set(placed, (Object)copy);
                    int n = i;
                    usedSlots[n] = usedSlots[n] + 1;
                    ++placed;
                    continue block3;
                }
            }
        }
        return CraftingInput.ofPositioned((int)3, (int)3, (List)grid).input();
    }

    public void craftRecipeById(ResourceLocation recipeId, boolean shiftClick) {
        CraftingInput input;
        if (this.level.isClientSide) {
            return;
        }
        RecipeManager rm = this.level.getRecipeManager();
        Optional optionalRecipe = rm.byKey(recipeId);
        if (optionalRecipe.isEmpty()) {
            return;
        }
        Recipe recipeHolder = ((RecipeHolder)optionalRecipe.get()).value();
        if (!(recipeHolder instanceof CraftingRecipe)) {
            return;
        }
        CraftingRecipe craftingRecipe = (CraftingRecipe)recipeHolder;
        int maxCrafts = shiftClick ? this.getMaxCraftableAmount(craftingRecipe) : 1;
        for (int i = 0; i < maxCrafts && craftingRecipe.matches((RecipeInput)(input = this.buildCraftingInputForRecipe(craftingRecipe, this.player.getInventory())), this.level); ++i) {
            NonNullList remainingItems = craftingRecipe.getRemainingItems((RecipeInput)input);
            block1: for (int j = 0; j < craftingRecipe.getIngredients().size(); ++j) {
                Ingredient ingredient = (Ingredient)craftingRecipe.getIngredients().get(j);
                if (ingredient.isEmpty()) continue;
                for (int k = 0; k < this.player.getInventory().getContainerSize(); ++k) {
                    ItemStack stack = this.player.getInventory().getItem(k);
                    if (!ingredient.test(stack)) continue;
                    stack.shrink(1);
                    if (!stack.isEmpty()) continue block1;
                    this.player.getInventory().setItem(k, ItemStack.EMPTY);
                    continue block1;
                }
            }
            for (ItemStack remainder : remainingItems) {
                if (remainder.isEmpty() || this.player.getInventory().add(remainder)) continue;
                this.player.drop(remainder, false);
            }
            ItemStack result = craftingRecipe.assemble((RecipeInput)input, (HolderLookup.Provider)this.level.registryAccess());
            this.player.getInventory().placeItemBackInInventory(result);
        }
        this.player.playNotifySound(SoundEvents.LEVER_CLICK, SoundSource.PLAYERS, 1.0f, 1.0f);
        this.player.getInventory().setChanged();
        this.player.inventoryMenu.broadcastChanges();
        this.updateValidRecipes();
    }

    private int getMaxCraftableAmount(CraftingRecipe recipe) {
        Inventory inv = this.player.getInventory();
        int max = Integer.MAX_VALUE;
        for (Ingredient ingredient : recipe.getIngredients()) {
            if (ingredient.isEmpty()) continue;
            int count = 0;
            for (ItemStack stack : inv.items) {
                if (!ingredient.test(stack)) continue;
                count += stack.getCount();
            }
            int possible = count / 1;
            if (possible >= max) continue;
            max = possible;
        }
        return Math.max(0, Math.min(max, 64));
    }

    public void broadcastChanges() {
        int i;
        super.broadcastChanges();
        if (this.level.isClientSide) {
            return;
        }
        boolean changed = false;
        NonNullList current = this.player.getInventory().items;
        for (i = 0; i < current.size(); ++i) {
            ItemStack newStack;
            ItemStack oldStack = (ItemStack)this.lastInventorySnapshot.get(i);
            if (ItemStack.matches((ItemStack)oldStack, (ItemStack)(newStack = (ItemStack)current.get(i)))) continue;
            changed = true;
            break;
        }
        if (changed) {
            this.updateValidRecipes();
            for (i = 0; i < current.size(); ++i) {
                this.lastInventorySnapshot.set(i, (Object)((ItemStack)current.get(i)).copy());
            }
        }
    }

    @NotNull
    public ItemStack quickMoveStack(Player p_38941_, int p_38942_) {
        return ItemStack.EMPTY;
    }

    public boolean stillValid(@NotNull Player player) {
        return true;
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.addSlot(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 84 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }
}

