/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.opolisutilities.screen.custom;

import com.benbenlaw.opolisutilities.block.custom.EnderScramblerBlock;
import com.benbenlaw.opolisutilities.block.entity.custom.EnderScramblerBlockEntity;
import com.benbenlaw.opolisutilities.networking.payload.DecreaseTickButtonPayload;
import com.benbenlaw.opolisutilities.networking.payload.IncreaseTickButtonPayload;
import com.benbenlaw.opolisutilities.networking.payload.OnOffButtonPayload;
import com.benbenlaw.opolisutilities.screen.custom.EnderScramblerMenu;
import com.benbenlaw.opolisutilities.screen.utils.ModButtons;
import com.benbenlaw.opolisutilities.util.MouseUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnderScramblerScreen
extends AbstractContainerScreen<EnderScramblerMenu> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"opolisutilities", (String)"textures/gui/ender_scrambler_gui.png");

    public EnderScramblerScreen(EnderScramblerMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
    }

    protected void init() {
        super.init();
        this.addMenuButtons();
    }

    protected void containerTick() {
        this.clearWidgets();
        this.addMenuButtons();
    }

    protected void renderBg(GuiGraphics guiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(TEXTURE, x, y, 0, 0, this.imageWidth, this.imageHeight);
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        this.renderBackground(guiGraphics, mouseX, mouseY, delta);
        super.render(guiGraphics, mouseX, mouseY, delta);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        this.renderRange(guiGraphics, mouseX, mouseY, x, y);
    }

    @Nullable
    private void renderRange(GuiGraphics guiGraphics, int mouseX, int mouseY, int x, int y) {
        if (MouseUtil.isMouseAboveArea(mouseX, mouseY, x, y, 4, 13, 20, 54)) {
            int ticks = 0;
            BlockEntity blockEntity = ((EnderScramblerMenu)this.menu).level.getBlockEntity(((EnderScramblerMenu)this.menu).blockPos);
            if (blockEntity instanceof EnderScramblerBlockEntity) {
                EnderScramblerBlockEntity enderScramblerBlockEntity = (EnderScramblerBlockEntity)blockEntity;
                ticks = enderScramblerBlockEntity.SCRAMBLER_RANGE;
            }
            guiGraphics.drawString(this.font, ticks + " range", this.leftPos + 90, this.topPos + 60, 0x3F3F3F, false);
        }
    }

    private void addMenuButtons() {
        if (!((Boolean)((EnderScramblerMenu)this.menu).blockEntity.getBlockState().getValue((Property)EnderScramblerBlock.POWERED)).booleanValue()) {
            this.addRenderableWidget((GuiEventListener)new ImageButton(this.leftPos + 5, this.height / 2 - 49, 20, 18, ModButtons.OFF_BUTTONS, pressed -> PacketDistributor.sendToServer((CustomPacketPayload)new OnOffButtonPayload(((EnderScramblerMenu)this.menu).blockEntity.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0])));
        } else {
            this.addRenderableWidget((GuiEventListener)new ImageButton(this.leftPos + 5, this.height / 2 - 49, 20, 18, ModButtons.ON_BUTTONS, pressed -> PacketDistributor.sendToServer((CustomPacketPayload)new OnOffButtonPayload(((EnderScramblerMenu)this.menu).blockEntity.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0])));
        }
        boolean isShiftDown = EnderScramblerScreen.hasShiftDown();
        this.addRenderableWidget((GuiEventListener)new ImageButton(this.leftPos + 5, this.height / 2 - 32, 20, 18, ModButtons.DECREASE_BUTTONS, pressed -> PacketDistributor.sendToServer((CustomPacketPayload)new DecreaseTickButtonPayload(((EnderScramblerMenu)this.menu).blockEntity.getBlockPos(), isShiftDown), (CustomPacketPayload[])new CustomPacketPayload[0])));
        this.addRenderableWidget((GuiEventListener)new ImageButton(this.leftPos + 5, this.height / 2 - 66, 20, 18, ModButtons.INCREASE_BUTTONS, pressed -> PacketDistributor.sendToServer((CustomPacketPayload)new IncreaseTickButtonPayload(((EnderScramblerMenu)this.menu).blockEntity.getBlockPos(), isShiftDown), (CustomPacketPayload[])new CustomPacketPayload[0])));
    }
}

