/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.opolisutilities.recipe;

import com.benbenlaw.opolisutilities.recipe.NoInventoryRecipe;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public record SpeedUpgradesRecipe(Ingredient input, int tickRate) implements Recipe<NoInventoryRecipe>
{
    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        NonNullList ingredients = NonNullList.createWithCapacity((int)1);
        ingredients.add((Object)this.input);
        return ingredients;
    }

    public boolean matches(@NotNull NoInventoryRecipe inv, @NotNull Level pLevel) {
        return true;
    }

    @NotNull
    public ItemStack assemble(@NotNull NoInventoryRecipe inv, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return true;
    }

    @NotNull
    public ItemStack getResultItem(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    @NotNull
    public RecipeType<?> getType() {
        return Type.INSTANCE;
    }

    public boolean isSpecial() {
        return true;
    }

    public static class Serializer
    implements RecipeSerializer<SpeedUpgradesRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public final MapCodec<SpeedUpgradesRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("input").forGetter(SpeedUpgradesRecipe::input), (App)Codec.INT.fieldOf("tickRate").forGetter(SpeedUpgradesRecipe::tickRate)).apply((Applicative)instance, SpeedUpgradesRecipe::new));
        private final StreamCodec<RegistryFriendlyByteBuf, SpeedUpgradesRecipe> STREAM_CODEC = StreamCodec.of(Serializer::write, Serializer::read);

        @NotNull
        public MapCodec<SpeedUpgradesRecipe> codec() {
            return this.CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, SpeedUpgradesRecipe> streamCodec() {
            return this.STREAM_CODEC;
        }

        private static SpeedUpgradesRecipe read(RegistryFriendlyByteBuf buffer) {
            Ingredient input = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            int tickRate = buffer.readInt();
            return new SpeedUpgradesRecipe(input, tickRate);
        }

        private static void write(RegistryFriendlyByteBuf buffer, SpeedUpgradesRecipe recipe) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.input);
            buffer.writeInt(recipe.tickRate);
        }
    }

    public static class Type
    implements RecipeType<SpeedUpgradesRecipe> {
        public static final Type INSTANCE = new Type();

        private Type() {
        }
    }
}

