/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.opolisutilities.item.custom;

import com.benbenlaw.opolisutilities.item.ModDataComponents;
import com.benbenlaw.opolisutilities.util.ModTags;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.fml.ModList;
import org.jetbrains.annotations.NotNull;

public class PortableGUIItem
extends Item {
    public PortableGUIItem(Item.Properties properties) {
        super(properties);
    }

    public void onCraftedBy(ItemStack stack, @NotNull Level level, @NotNull Player player) {
        stack.set(ModDataComponents.LOCATION_VALUE, (Object)1);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int tick, boolean noideawhatthisis) {
        if (stack.get(ModDataComponents.LOCATION_VALUE) == null) {
            stack.set(ModDataComponents.LOCATION_VALUE, (Object)1);
        }
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack itemstack;
        block31: {
            itemstack = player.getItemInHand(hand);
            BlockHitResult blockHitResult = PortableGUIItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
            if (!level.isClientSide() && itemstack.getItem() instanceof PortableGUIItem) {
                String location;
                ServerLevel serverLevel = (ServerLevel)level;
                if (blockHitResult.getType() == HitResult.Type.BLOCK && player.isCrouching()) {
                    BlockPos blockPos = blockHitResult.getBlockPos();
                    BlockState blockState = level.getBlockState(blockPos);
                    if (!blockState.is(ModTags.Blocks.BANNED_IN_PORTABLE_GUI)) {
                        int locationValue = itemstack.get(ModDataComponents.LOCATION_VALUE) != null ? (Integer)itemstack.get(ModDataComponents.LOCATION_VALUE) : 1;
                        int blockX = blockPos.getX();
                        int blockY = blockPos.getY();
                        int blockZ = blockPos.getZ();
                        String blockName = blockState.getBlock().getDescriptionId();
                        switch (locationValue) {
                            case 1: {
                                itemstack.set(ModDataComponents.LOCATION_1, (Object)(blockX + " " + blockY + " " + blockZ));
                                itemstack.set(ModDataComponents.BLOCK_NAME_1, (Object)blockName);
                                break;
                            }
                            case 2: {
                                itemstack.set(ModDataComponents.LOCATION_2, (Object)(blockX + " " + blockY + " " + blockZ));
                                itemstack.set(ModDataComponents.BLOCK_NAME_2, (Object)blockName);
                                break;
                            }
                            case 3: {
                                itemstack.set(ModDataComponents.LOCATION_3, (Object)(blockX + " " + blockY + " " + blockZ));
                                itemstack.set(ModDataComponents.BLOCK_NAME_3, (Object)blockName);
                                break;
                            }
                            case 4: {
                                itemstack.set(ModDataComponents.LOCATION_4, (Object)(blockX + " " + blockY + " " + blockZ));
                                itemstack.set(ModDataComponents.BLOCK_NAME_4, (Object)blockName);
                                break;
                            }
                            case 5: {
                                itemstack.set(ModDataComponents.LOCATION_5, (Object)(blockX + " " + blockY + " " + blockZ));
                                itemstack.set(ModDataComponents.BLOCK_NAME_5, (Object)blockName);
                            }
                        }
                        return InteractionResultHolder.success((Object)itemstack);
                    }
                    player.sendSystemMessage((Component)Component.translatable((String)"tooltips.portable_gui.banned_block").withStyle(ChatFormatting.RED));
                    return InteractionResultHolder.fail((Object)itemstack);
                }
                int locationValue = (Integer)itemstack.get(ModDataComponents.LOCATION_VALUE);
                switch (locationValue) {
                    case 1: {
                        location = (String)itemstack.get(ModDataComponents.LOCATION_1);
                        break;
                    }
                    case 2: {
                        location = (String)itemstack.get(ModDataComponents.LOCATION_2);
                        break;
                    }
                    case 3: {
                        location = (String)itemstack.get(ModDataComponents.LOCATION_3);
                        break;
                    }
                    case 4: {
                        location = (String)itemstack.get(ModDataComponents.LOCATION_4);
                        break;
                    }
                    case 5: {
                        location = (String)itemstack.get(ModDataComponents.LOCATION_5);
                        break;
                    }
                    default: {
                        player.sendSystemMessage((Component)Component.translatable((String)"tooltips.portable_gui.invalid_location_value").withStyle(ChatFormatting.RED));
                        return InteractionResultHolder.fail((Object)itemstack);
                    }
                }
                if (location != null && !location.isEmpty()) {
                    String[] coordinates = location.split(" ");
                    if (coordinates.length == 3) {
                        try {
                            int x = Integer.parseInt(coordinates[0]);
                            int y = Integer.parseInt(coordinates[1]);
                            int z = Integer.parseInt(coordinates[2]);
                            BlockPos savedBlockPos = new BlockPos(x, y, z);
                            if (serverLevel.isLoaded(savedBlockPos)) {
                                BlockState savedBlockState = serverLevel.getBlockState(savedBlockPos);
                                BlockEntity blockEntity = serverLevel.getBlockEntity(savedBlockPos);
                                System.out.println("BlockEntity: " + String.valueOf(blockEntity));
                                MenuProvider menuProvider = savedBlockState.getMenuProvider((Level)serverLevel, savedBlockPos);
                                serverLevel.getChunkSource().updateChunkForced(new ChunkPos(savedBlockPos), true);
                                if (ModList.get().isLoaded("mekanism") && savedBlockState.getBlock().toString().contains("mekanism:")) {
                                    try {
                                        Class<?> tileEntityMekanismClass = Class.forName("mekanism.common.tile.base.TileEntityMekanism");
                                        Class<?> attributeClass = Class.forName("mekanism.common.block.attribute.Attribute");
                                        Class<?> attributeGuiClass = Class.forName("mekanism.common.block.attribute.AttributeGui");
                                        Method getOrThrowMethod = attributeClass.getMethod("getOrThrow", BlockState.class, Class.class);
                                        Object provider = getOrThrowMethod.invoke(null, savedBlockState, attributeGuiClass);
                                        menuProvider = (MenuProvider)provider.getClass().getMethod("getProvider", tileEntityMekanismClass, Boolean.TYPE).invoke(provider, serverLevel.getBlockEntity(savedBlockPos), true);
                                    }
                                    catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                                        e.printStackTrace(new PrintStream(System.out));
                                    }
                                }
                                if (ModList.get().isLoaded("chipped") && savedBlockState.getBlock().toString().contains("chipped:")) {
                                    try {
                                        Class<?> workbenchMenuProviderClass = Class.forName("earth.terrarium.chipped.common.menus.WorkbenchMenuProvider");
                                        Constructor<?> constructor = workbenchMenuProviderClass.getConstructor(Component.class);
                                        menuProvider = (MenuProvider)constructor.newInstance(Component.translatable((String)savedBlockState.getBlock().getDescriptionId()));
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace(new PrintStream(System.out));
                                    }
                                }
                                if (menuProvider != null) {
                                    System.out.println("Block Entity " + String.valueOf(blockEntity));
                                    player.openMenu(menuProvider, savedBlockPos);
                                    return InteractionResultHolder.success((Object)itemstack);
                                }
                                player.sendSystemMessage((Component)Component.translatable((String)"tooltips.portable_gui.no_gui").withStyle(ChatFormatting.RED));
                                break block31;
                            }
                            player.sendSystemMessage((Component)Component.translatable((String)"tooltips.portable_gui.not_loaded").withStyle(ChatFormatting.RED));
                        }
                        catch (NumberFormatException e) {
                            player.sendSystemMessage((Component)Component.translatable((String)"tooltips.portable_gui.invalid_location").withStyle(ChatFormatting.RED));
                        }
                    } else {
                        player.sendSystemMessage((Component)Component.translatable((String)"tooltips.portable_gui.invalid_location_format").withStyle(ChatFormatting.RED));
                    }
                } else {
                    player.sendSystemMessage((Component)Component.translatable((String)"tooltips.portable_gui.no_location").withStyle(ChatFormatting.RED));
                }
            }
        }
        return InteractionResultHolder.fail((Object)itemstack);
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> components, TooltipFlag flag) {
        String location;
        String blockName = "Unknown Block";
        Integer locationValue = (Integer)itemStack.get(ModDataComponents.LOCATION_VALUE);
        if (locationValue == null) {
            locationValue = -1;
        }
        String locationMessage = "tooltips.portable_gui.no_location";
        switch (locationValue) {
            case 1: {
                location = (String)itemStack.get(ModDataComponents.LOCATION_1);
                blockName = (String)itemStack.get(ModDataComponents.BLOCK_NAME_1);
                break;
            }
            case 2: {
                location = (String)itemStack.get(ModDataComponents.LOCATION_2);
                blockName = (String)itemStack.get(ModDataComponents.BLOCK_NAME_2);
                break;
            }
            case 3: {
                location = (String)itemStack.get(ModDataComponents.LOCATION_3);
                blockName = (String)itemStack.get(ModDataComponents.BLOCK_NAME_3);
                break;
            }
            case 4: {
                location = (String)itemStack.get(ModDataComponents.LOCATION_4);
                blockName = (String)itemStack.get(ModDataComponents.BLOCK_NAME_4);
                break;
            }
            case 5: {
                location = (String)itemStack.get(ModDataComponents.LOCATION_5);
                blockName = (String)itemStack.get(ModDataComponents.BLOCK_NAME_5);
                break;
            }
            default: {
                location = null;
            }
        }
        if (location == null || location.trim().isEmpty()) {
            components.add((Component)Component.translatable((String)locationMessage).withStyle(ChatFormatting.RED));
            super.appendHoverText(itemStack, tooltipContext, components, flag);
            return;
        }
        if (blockName == null || blockName.trim().isEmpty()) {
            blockName = "Unknown Block";
        }
        if (Screen.hasShiftDown()) {
            components.add((Component)Component.translatable((String)blockName).withStyle(ChatFormatting.GREEN).append((Component)Component.translatable((String)"tooltips.portable_gui.shift.held")).append((Component)Component.literal((String)location.replace(" ", ", ")).withStyle(ChatFormatting.GREEN)));
        } else {
            components.add((Component)Component.translatable((String)"tooltips.portable_gui.hover.shift").withStyle(ChatFormatting.BLUE));
        }
        super.appendHoverText(itemStack, tooltipContext, components, flag);
    }

    @NotNull
    public Component getName(ItemStack itemStack) {
        Integer locationValue = (Integer)itemStack.get(ModDataComponents.LOCATION_VALUE);
        if (locationValue == null) {
            locationValue = -1;
        }
        String locationMessage = "item.opolisutilities.portable_gui";
        String location = null;
        String blockName = null;
        switch (locationValue) {
            case 1: {
                location = (String)itemStack.get(ModDataComponents.LOCATION_1);
                blockName = (String)itemStack.get(ModDataComponents.BLOCK_NAME_1);
                break;
            }
            case 2: {
                location = (String)itemStack.get(ModDataComponents.LOCATION_2);
                blockName = (String)itemStack.get(ModDataComponents.BLOCK_NAME_2);
                break;
            }
            case 3: {
                location = (String)itemStack.get(ModDataComponents.LOCATION_3);
                blockName = (String)itemStack.get(ModDataComponents.BLOCK_NAME_3);
                break;
            }
            case 4: {
                location = (String)itemStack.get(ModDataComponents.LOCATION_4);
                blockName = (String)itemStack.get(ModDataComponents.BLOCK_NAME_4);
                break;
            }
            case 5: {
                location = (String)itemStack.get(ModDataComponents.LOCATION_5);
                blockName = (String)itemStack.get(ModDataComponents.BLOCK_NAME_5);
                break;
            }
        }
        if (location != null && !location.trim().isEmpty()) {
            if (blockName == null || blockName.trim().isEmpty()) {
                blockName = "Unknown Block";
            }
            return Component.translatable((String)locationMessage).append(" ").append((Component)Component.translatable((String)blockName).withStyle(ChatFormatting.GREEN)).append((Component)Component.literal((String)(" (" + locationValue + ")")).withStyle(ChatFormatting.BLUE));
        }
        return Component.translatable((String)locationMessage).append(" ").append((Component)Component.literal((String)(" (" + locationValue + ")")).withStyle(ChatFormatting.BLUE));
    }
}

